/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaResponseMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.ResponseHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CancelResponse
extends Structure
implements UaResponseMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=480");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=482");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=481");
    private final ResponseHeader responseHeader;
    private final UInteger cancelCount;

    public CancelResponse(ResponseHeader responseHeader, UInteger cancelCount) {
        this.responseHeader = responseHeader;
        this.cancelCount = cancelCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public UInteger getCancelCount() {
        return this.cancelCount;
    }

    protected CancelResponse(CancelResponseBuilder<?, ?> b) {
        super(b);
        this.responseHeader = ((CancelResponseBuilder)b).responseHeader;
        this.cancelCount = ((CancelResponseBuilder)b).cancelCount;
    }

    public static CancelResponseBuilder<?, ?> builder() {
        return new CancelResponseBuilderImpl();
    }

    public CancelResponseBuilder<?, ?> toBuilder() {
        return new CancelResponseBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelResponse)) {
            return false;
        }
        CancelResponse other = (CancelResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseHeader this$responseHeader = this.getResponseHeader();
        ResponseHeader other$responseHeader = other.getResponseHeader();
        if (this$responseHeader == null ? other$responseHeader != null : !((Object)this$responseHeader).equals(other$responseHeader)) {
            return false;
        }
        UInteger this$cancelCount = this.getCancelCount();
        UInteger other$cancelCount = other.getCancelCount();
        return !(this$cancelCount == null ? other$cancelCount != null : !((Object)this$cancelCount).equals(other$cancelCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CancelResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseHeader $responseHeader = this.getResponseHeader();
        result = result * 59 + ($responseHeader == null ? 43 : ((Object)$responseHeader).hashCode());
        UInteger $cancelCount = this.getCancelCount();
        result = result * 59 + ($cancelCount == null ? 43 : ((Object)$cancelCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CancelResponse(responseHeader=" + this.getResponseHeader() + ", cancelCount=" + this.getCancelCount() + ")";
    }

    private static final class CancelResponseBuilderImpl
    extends CancelResponseBuilder<CancelResponse, CancelResponseBuilderImpl> {
        private CancelResponseBuilderImpl() {
        }

        @Override
        protected CancelResponseBuilderImpl self() {
            return this;
        }

        @Override
        public CancelResponse build() {
            return new CancelResponse(this);
        }
    }

    public static abstract class CancelResponseBuilder<C extends CancelResponse, B extends CancelResponseBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ResponseHeader responseHeader;
        private UInteger cancelCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CancelResponseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CancelResponse instance, CancelResponseBuilder<?, ?> b) {
            b.responseHeader(instance.responseHeader);
            b.cancelCount(instance.cancelCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B responseHeader(ResponseHeader responseHeader) {
            this.responseHeader = responseHeader;
            return (B)this.self();
        }

        public B cancelCount(UInteger cancelCount) {
            this.cancelCount = cancelCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CancelResponse.CancelResponseBuilder(super=" + super.toString() + ", responseHeader=" + this.responseHeader + ", cancelCount=" + this.cancelCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CancelResponse> {
        @Override
        public Class<CancelResponse> getType() {
            return CancelResponse.class;
        }

        @Override
        public CancelResponse decode(SerializationContext context, UaDecoder decoder) {
            ResponseHeader responseHeader = (ResponseHeader)decoder.readStruct("ResponseHeader", ResponseHeader.TYPE_ID);
            UInteger cancelCount = decoder.readUInt32("CancelCount");
            return new CancelResponse(responseHeader, cancelCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CancelResponse value) {
            encoder.writeStruct("ResponseHeader", (Object)value.getResponseHeader(), ResponseHeader.TYPE_ID);
            encoder.writeUInt32("CancelCount", value.getCancelCount());
        }
    }
}

