/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.server;

import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.server.EndpointConfiguration;
import org.eclipse.milo.opcua.stack.server.UaStackServerConfigBuilder;
import org.eclipse.milo.opcua.stack.server.security.ServerCertificateValidator;

public interface UaStackServerConfig {
    public Set<EndpointConfiguration> getEndpoints();

    public LocalizedText getApplicationName();

    public String getApplicationUri();

    public String getProductUri();

    public EncodingLimits getEncodingLimits();

    public UInteger getMinimumSecureChannelLifetime();

    public UInteger getMaximumSecureChannelLifetime();

    public CertificateManager getCertificateManager();

    public TrustListManager getTrustListManager();

    public ServerCertificateValidator getCertificateValidator();

    public Optional<KeyPair> getHttpsKeyPair();

    @Deprecated
    default public Optional<X509Certificate> getHttpsCertificate() {
        return this.getHttpsCertificateChain().flatMap(chain -> Optional.ofNullable(chain[0]));
    }

    public Optional<X509Certificate[]> getHttpsCertificateChain();

    public ExecutorService getExecutor();

    public static UaStackServerConfigBuilder builder() {
        return new UaStackServerConfigBuilder();
    }

    public static UaStackServerConfigBuilder copy(UaStackServerConfig config) {
        UaStackServerConfigBuilder builder = UaStackServerConfig.builder();
        builder.setEndpoints(config.getEndpoints());
        builder.setApplicationName(config.getApplicationName());
        builder.setApplicationUri(config.getApplicationUri());
        builder.setProductUri(config.getProductUri());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setMinimumSecureChannelLifetime(config.getMinimumSecureChannelLifetime());
        builder.setMaximumSecureChannelLifetime(config.getMaximumSecureChannelLifetime());
        builder.setCertificateManager(config.getCertificateManager());
        builder.setTrustListManager(config.getTrustListManager());
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setHttpsKeyPair(config.getHttpsKeyPair().orElse(null));
        builder.setHttpsCertificateChain(config.getHttpsCertificateChain().orElse(null));
        builder.setExecutor(config.getExecutor());
        return builder;
    }

    public static UaStackServerConfig copy(UaStackServerConfig config, Consumer<UaStackServerConfigBuilder> consumer) {
        UaStackServerConfigBuilder builder = UaStackServerConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

