/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.transformation.dag.column.binary;

import java.time.ZoneId;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.db.queryengine.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.queryengine.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.read.common.type.Type;

public class TimestampAdditionLongColumnTransformer
extends BinaryColumnTransformer {
    private static ZoneId zoneId;

    public TimestampAdditionLongColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer, ZoneId zoneId) {
        super(returnType, leftTransformer, rightTransformer);
        TimestampAdditionLongColumnTransformer.zoneId = zoneId;
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                this.returnType.writeLong(builder, TimestampAdditionLongColumnTransformer.transform(this.leftTransformer.getType().getLong(leftColumn, i), this.rightTransformer.getType().getLong(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount, boolean[] selection) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i) && selection[i]) {
                this.returnType.writeLong(builder, TimestampAdditionLongColumnTransformer.transform(this.leftTransformer.getType().getLong(leftColumn, i), this.rightTransformer.getType().getLong(rightColumn, i)));
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
    }

    public static long transform(long left, long right) {
        try {
            return Math.addExact(left, right);
        }
        catch (ArithmeticException e) {
            throw new IoTDBRuntimeException(String.format("long Addition overflow: %s + %s", left, right), TSStatusCode.NUMERIC_VALUE_OUT_OF_RANGE.getStatusCode(), true);
        }
    }
}

