/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.schedule.queue;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.ID;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.queryengine.execution.schedule.queue.IndexedBlockingQueue;

public class L1PriorityQueue<E extends IDIndexedAccessible>
extends IndexedBlockingQueue<E> {
    private final SortedSet<E> sortedElements;
    private final Map<ID, E> keyedElements;

    public L1PriorityQueue(int maxCapacity, Comparator<E> comparator, E queryHolder) {
        super(maxCapacity, queryHolder);
        this.sortedElements = new TreeSet<E>(comparator);
        this.keyedElements = new HashMap<ID, E>();
    }

    @Override
    protected boolean isEmpty() {
        return this.keyedElements.isEmpty();
    }

    @Override
    protected E pollFirst() {
        IDIndexedAccessible element = (IDIndexedAccessible)this.sortedElements.first();
        this.sortedElements.remove(element);
        this.keyedElements.remove(element.getDriverTaskId());
        return (E)element;
    }

    @Override
    protected void pushToQueue(E element) {
        this.keyedElements.put(element.getDriverTaskId(), element);
        this.sortedElements.add(element);
    }

    @Override
    protected E remove(E element) {
        IDIndexedAccessible e = (IDIndexedAccessible)this.keyedElements.remove(element.getDriverTaskId());
        if (e != null) {
            this.sortedElements.remove(e);
        }
        return (E)e;
    }

    @Override
    protected boolean contains(E element) {
        return this.keyedElements.containsKey(element.getDriverTaskId());
    }

    @Override
    protected E get(E element) {
        return (E)((IDIndexedAccessible)this.keyedElements.get(element.getDriverTaskId()));
    }

    @Override
    protected void clearAllElements() {
        this.sortedElements.clear();
        this.keyedElements.clear();
    }
}

