/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet.parser;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.file.metadata.StringArrayDeviceID;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.write.UnSupportedDataTypeException;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabletInsertionEventParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabletInsertionEventParser.class);
    private static final LocalDate EMPTY_LOCALDATE = LocalDate.of(1000, 1, 1);
    protected final PipeTaskMeta pipeTaskMeta;
    protected final EnrichedEvent sourceEvent;
    protected IDeviceID deviceId;
    protected String deviceIdString;
    protected boolean isAligned;
    protected IMeasurementSchema[] measurementSchemaList;
    protected String[] columnNameStringList;
    protected long[] timestampColumn;
    protected ColumnCategory[] valueColumnTypes;
    protected TSDataType[] valueColumnDataTypes;
    protected Object[] valueColumns;
    protected BitMap[] nullValueColumnBitmaps;
    protected int rowCount;
    protected Tablet tablet;
    protected boolean shouldReport = false;
    protected static final Integer CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER = 16;
    protected static final Map<Integer, List<Integer>> CACHED_FULL_ROW_INDEX_LIST = new HashMap<Integer, List<Integer>>();

    protected TabletInsertionEventParser(PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent) {
        this.pipeTaskMeta = pipeTaskMeta;
        this.sourceEvent = sourceEvent;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public void markAsNeedToReport() {
        this.shouldReport = true;
    }

    protected abstract Object getPattern();

    protected void parse(InsertRowNode insertRowNode) {
        int originColumnSize = insertRowNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceIdString = insertRowNode.getTargetPath().getFullPath();
        this.deviceId = insertRowNode.getDeviceID();
        this.isAligned = insertRowNode.isAligned();
        long[] originTimestampColumn = new long[]{insertRowNode.getTime()};
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        this.generateColumnIndexMapper(insertRowNode.getMeasurements(), originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnDataTypes = new TSDataType[filteredColumnSize];
        this.valueColumnTypes = new ColumnCategory[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertRowNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertRowNode.getMeasurements();
        TsTableColumnCategory[] originColumnCategories = insertRowNode.getColumnCategories();
        TSDataType[] originValueDataTypes = insertRowNode.getDataTypes();
        Object[] originValues = insertRowNode.getValues();
        for (int i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i2];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originColumnCategories != null && originColumnCategories[i2] != null ? originColumnCategories[i2].toTsFileColumnType() : ColumnCategory.FIELD;
            this.valueColumnDataTypes[filteredColumnIndex] = originValueDataTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValues[i2]) || Objects.isNull(originValueDataTypes[i2])) {
                this.fillNullValue(originValueDataTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionEventParser.filterValueColumnsByRowIndexList(originValueDataTypes[i2], originValues[i2], rowIndexList, true, bitMap, bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("InsertRowNode({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{insertRowNode, this.getPattern(), this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    protected void parse(InsertTabletNode insertTabletNode) {
        int i2;
        int originColumnSize = insertTabletNode.getMeasurements().length;
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceIdString = insertTabletNode.getTargetPath().getFullPath();
        this.deviceId = insertTabletNode.getDeviceID();
        this.isAligned = insertTabletNode.isAligned();
        long[] originTimestampColumn = insertTabletNode.getTimes();
        int originRowSize = originTimestampColumn.length;
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        this.generateColumnIndexMapper(insertTabletNode.getMeasurements(), originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new ColumnCategory[filteredColumnSize];
        this.valueColumnDataTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        MeasurementSchema[] originMeasurementSchemaList = insertTabletNode.getMeasurementSchemas();
        String[] originColumnNameStringList = insertTabletNode.getMeasurements();
        TsTableColumnCategory[] originColumnCategories = insertTabletNode.getColumnCategories();
        TSDataType[] originValueColumnDataTypes = insertTabletNode.getDataTypes();
        Object[] originValueColumns = insertTabletNode.getColumns();
        BitMap[] originBitMapList = insertTabletNode.getBitMaps() == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(originRowSize)).toArray(BitMap[]::new) : insertTabletNode.getBitMaps();
        for (i2 = 0; i2 < originBitMapList.length; ++i2) {
            if (originBitMapList[i2] != null) continue;
            originBitMapList[i2] = new BitMap(originRowSize);
        }
        for (i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = originMeasurementSchemaList[i2];
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originColumnCategories != null && originColumnCategories[i2] != null ? originColumnCategories[i2].toTsFileColumnType() : ColumnCategory.FIELD;
            this.valueColumnDataTypes[filteredColumnIndex] = originValueColumnDataTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValueColumns[i2]) || Objects.isNull(originValueColumnDataTypes[i2])) {
                this.fillNullValue(originValueColumnDataTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionEventParser.filterValueColumnsByRowIndexList(originValueColumnDataTypes[i2], originValueColumns[i2], rowIndexList, false, originBitMapList[i2], bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("InsertTabletNode({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{insertTabletNode, this.getPattern(), this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    protected void parse(Tablet tablet, boolean isAligned) {
        int i2;
        int originColumnSize = tablet.getSchemas().size();
        Integer[] originColumnIndex2FilteredColumnIndexMapperList = new Integer[originColumnSize];
        this.deviceIdString = tablet.getDeviceId();
        this.deviceId = new StringArrayDeviceID(tablet.getDeviceId());
        this.isAligned = isAligned;
        long[] originTimestampColumn = Arrays.copyOf(tablet.getTimestamps(), tablet.getRowSize());
        List<Integer> rowIndexList = this.generateRowIndexList(originTimestampColumn);
        this.timestampColumn = rowIndexList.stream().mapToLong(i -> originTimestampColumn[i]).toArray();
        List originMeasurementSchemaList = tablet.getSchemas();
        String[] originMeasurementList = new String[originMeasurementSchemaList.size()];
        for (int i3 = 0; i3 < originMeasurementSchemaList.size(); ++i3) {
            originMeasurementList[i3] = ((IMeasurementSchema)originMeasurementSchemaList.get(i3)).getMeasurementName();
        }
        this.generateColumnIndexMapper(originMeasurementList, originColumnIndex2FilteredColumnIndexMapperList);
        int filteredColumnSize = Arrays.stream(originColumnIndex2FilteredColumnIndexMapperList).filter(Objects::nonNull).toArray().length;
        this.measurementSchemaList = new MeasurementSchema[filteredColumnSize];
        this.columnNameStringList = new String[filteredColumnSize];
        this.valueColumnTypes = new ColumnCategory[filteredColumnSize];
        this.valueColumnDataTypes = new TSDataType[filteredColumnSize];
        this.valueColumns = new Object[filteredColumnSize];
        this.nullValueColumnBitmaps = new BitMap[filteredColumnSize];
        String[] originColumnNameStringList = new String[originColumnSize];
        ColumnCategory[] originColumnTypes = new ColumnCategory[originColumnSize];
        TSDataType[] originValueColumnDataTypes = new TSDataType[originColumnSize];
        for (int i4 = 0; i4 < originColumnSize; ++i4) {
            originColumnNameStringList[i4] = ((IMeasurementSchema)originMeasurementSchemaList.get(i4)).getMeasurementName();
            originColumnTypes[i4] = tablet.getColumnTypes() != null && tablet.getColumnTypes().get(i4) != null ? (ColumnCategory)tablet.getColumnTypes().get(i4) : ColumnCategory.FIELD;
            originValueColumnDataTypes[i4] = ((IMeasurementSchema)originMeasurementSchemaList.get(i4)).getType();
        }
        Object[] originValueColumns = tablet.getValues();
        BitMap[] originBitMapList = tablet.getBitMaps() == null ? (BitMap[])IntStream.range(0, originColumnSize).boxed().map(o -> new BitMap(tablet.getMaxRowNumber())).toArray(BitMap[]::new) : tablet.getBitMaps();
        for (i2 = 0; i2 < originBitMapList.length; ++i2) {
            if (originBitMapList[i2] != null) continue;
            originBitMapList[i2] = new BitMap(tablet.getMaxRowNumber());
        }
        for (i2 = 0; i2 < originColumnIndex2FilteredColumnIndexMapperList.length; ++i2) {
            if (originColumnIndex2FilteredColumnIndexMapperList[i2] == null) continue;
            int filteredColumnIndex = originColumnIndex2FilteredColumnIndexMapperList[i2];
            this.measurementSchemaList[filteredColumnIndex] = (IMeasurementSchema)originMeasurementSchemaList.get(i2);
            this.columnNameStringList[filteredColumnIndex] = originColumnNameStringList[i2];
            this.valueColumnTypes[filteredColumnIndex] = originColumnTypes[i2] != null ? originColumnTypes[i2] : ColumnCategory.FIELD;
            this.valueColumnDataTypes[filteredColumnIndex] = originValueColumnDataTypes[i2];
            BitMap bitMap = new BitMap(this.timestampColumn.length);
            if (Objects.isNull(originValueColumns[i2]) || Objects.isNull(originValueColumnDataTypes[i2])) {
                this.fillNullValue(originValueColumnDataTypes[i2], this.valueColumns, bitMap, filteredColumnIndex, rowIndexList.size());
            } else {
                this.valueColumns[filteredColumnIndex] = TabletInsertionEventParser.filterValueColumnsByRowIndexList(originValueColumnDataTypes[i2], originValueColumns[i2], rowIndexList, false, originBitMapList[i2], bitMap);
            }
            this.nullValueColumnBitmaps[filteredColumnIndex] = bitMap;
        }
        this.rowCount = this.timestampColumn.length;
        if (this.rowCount == 0 && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Tablet({}) is parsed to zero rows according to the pattern({}) and time range [{}, {}], the corresponding source event({}) will be ignored.", new Object[]{tablet, this.getPattern(), this.sourceEvent.getStartTime(), this.sourceEvent.getEndTime(), this.sourceEvent});
        }
    }

    protected abstract void generateColumnIndexMapper(String[] var1, Integer[] var2);

    private List<Integer> generateRowIndexList(long[] originTimestampColumn) {
        int rowCount = originTimestampColumn.length;
        if (Objects.isNull(this.sourceEvent) || !this.sourceEvent.shouldParseTime()) {
            return TabletInsertionEventParser.generateFullRowIndexList(rowCount);
        }
        ArrayList<Integer> rowIndexList = new ArrayList<Integer>();
        if (originTimestampColumn[originTimestampColumn.length - 1] < this.sourceEvent.getStartTime() || originTimestampColumn[0] > this.sourceEvent.getEndTime()) {
            return rowIndexList;
        }
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            if (this.sourceEvent.getStartTime() > originTimestampColumn[rowIndex] || originTimestampColumn[rowIndex] > this.sourceEvent.getEndTime()) continue;
            rowIndexList.add(rowIndex);
        }
        return rowIndexList;
    }

    private static List<Integer> generateFullRowIndexList(int rowCount) {
        if (rowCount <= CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER) {
            return CACHED_FULL_ROW_INDEX_LIST.get(rowCount);
        }
        return IntStream.range(0, rowCount).boxed().collect(Collectors.toList());
    }

    private static Object filterValueColumnsByRowIndexList(@NonNull TSDataType type, @NonNull Object originValueColumn, @NonNull List<Integer> rowIndexList, boolean isSingleOriginValueColumn, @NonNull BitMap originNullValueColumnBitmap, @NonNull BitMap nullValueColumnBitmap) {
        switch (type) {
            case INT32: {
                int[] nArray;
                if (isSingleOriginValueColumn) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = (Integer)originValueColumn;
                } else {
                    nArray = (int[])originValueColumn;
                }
                int[] intValueColumns = nArray;
                int[] valueColumns = new int[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = intValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case DATE: {
                LocalDate[] valueColumns = new LocalDate[rowIndexList.size()];
                if (isSingleOriginValueColumn && originValueColumn instanceof LocalDate || !isSingleOriginValueColumn && originValueColumn instanceof LocalDate[]) {
                    LocalDate[] localDateArray;
                    if (isSingleOriginValueColumn) {
                        LocalDate[] localDateArray2 = new LocalDate[1];
                        localDateArray = localDateArray2;
                        localDateArray2[0] = (LocalDate)originValueColumn;
                    } else {
                        localDateArray = (LocalDate[])originValueColumn;
                    }
                    LocalDate[] dateValueColumns = localDateArray;
                    for (int i = 0; i < rowIndexList.size(); ++i) {
                        if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                            valueColumns[i] = EMPTY_LOCALDATE;
                            nullValueColumnBitmap.mark(i);
                            continue;
                        }
                        valueColumns[i] = dateValueColumns[rowIndexList.get(i)];
                    }
                } else {
                    int[] nArray;
                    if (isSingleOriginValueColumn) {
                        int[] nArray3 = new int[1];
                        nArray = nArray3;
                        nArray3[0] = (Integer)originValueColumn;
                    } else {
                        nArray = (int[])originValueColumn;
                    }
                    int[] intValueColumns = nArray;
                    for (int i = 0; i < rowIndexList.size(); ++i) {
                        if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                            valueColumns[i] = EMPTY_LOCALDATE;
                            nullValueColumnBitmap.mark(i);
                            continue;
                        }
                        valueColumns[i] = DateUtils.parseIntToLocalDate((int)intValueColumns[rowIndexList.get(i)]);
                    }
                }
                return valueColumns;
            }
            case INT64: 
            case TIMESTAMP: {
                long[] lArray;
                if (isSingleOriginValueColumn) {
                    long[] lArray2 = new long[1];
                    lArray = lArray2;
                    lArray2[0] = (Long)originValueColumn;
                } else {
                    lArray = (long[])originValueColumn;
                }
                long[] longValueColumns = lArray;
                long[] valueColumns = new long[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0L;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = longValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case FLOAT: {
                float[] fArray;
                if (isSingleOriginValueColumn) {
                    float[] fArray2 = new float[1];
                    fArray = fArray2;
                    fArray2[0] = ((Float)originValueColumn).floatValue();
                } else {
                    fArray = (float[])originValueColumn;
                }
                float[] floatValueColumns = fArray;
                float[] valueColumns = new float[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0.0f;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = floatValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case DOUBLE: {
                double[] dArray;
                if (isSingleOriginValueColumn) {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = (Double)originValueColumn;
                } else {
                    dArray = (double[])originValueColumn;
                }
                double[] doubleValueColumns = dArray;
                double[] valueColumns = new double[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = 0.0;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = doubleValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case BOOLEAN: {
                boolean[] blArray;
                if (isSingleOriginValueColumn) {
                    boolean[] blArray2 = new boolean[1];
                    blArray = blArray2;
                    blArray2[0] = (Boolean)originValueColumn;
                } else {
                    blArray = (boolean[])originValueColumn;
                }
                boolean[] booleanValueColumns = blArray;
                boolean[] valueColumns = new boolean[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = false;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = booleanValueColumns[rowIndexList.get(i)];
                }
                return valueColumns;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Binary[] binaryArray;
                if (isSingleOriginValueColumn) {
                    Binary[] binaryArray2 = new Binary[1];
                    binaryArray = binaryArray2;
                    binaryArray2[0] = (Binary)originValueColumn;
                } else {
                    binaryArray = (Binary[])originValueColumn;
                }
                Binary[] binaryValueColumns = binaryArray;
                Binary[] valueColumns = new Binary[rowIndexList.size()];
                for (int i = 0; i < rowIndexList.size(); ++i) {
                    if (Objects.isNull(binaryValueColumns[rowIndexList.get(i)]) || Objects.isNull(binaryValueColumns[rowIndexList.get(i)].getValues()) || originNullValueColumnBitmap.isMarked(rowIndexList.get(i).intValue())) {
                        valueColumns[i] = Binary.EMPTY_VALUE;
                        nullValueColumnBitmap.mark(i);
                        continue;
                    }
                    valueColumns[i] = new Binary(binaryValueColumns[rowIndexList.get(i)].getValues());
                }
                return valueColumns;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
    }

    private void fillNullValue(TSDataType type, Object[] valueColumns, BitMap nullValueColumnBitmap, int columnIndex, int rowSize) {
        nullValueColumnBitmap.markAll();
        if (Objects.isNull(type)) {
            return;
        }
        switch (type) {
            case INT64: 
            case TIMESTAMP: {
                valueColumns[columnIndex] = new long[rowSize];
                break;
            }
            case INT32: {
                valueColumns[columnIndex] = new int[rowSize];
                break;
            }
            case DOUBLE: {
                valueColumns[columnIndex] = new double[rowSize];
                break;
            }
            case FLOAT: {
                valueColumns[columnIndex] = new float[rowSize];
                break;
            }
            case BOOLEAN: {
                valueColumns[columnIndex] = new boolean[rowSize];
                break;
            }
            case DATE: {
                Object[] dates = new LocalDate[rowSize];
                Arrays.fill(dates, EMPTY_LOCALDATE);
                valueColumns[columnIndex] = dates;
                break;
            }
            case TEXT: 
            case BLOB: 
            case STRING: {
                Object[] columns = new Binary[rowSize];
                Arrays.fill(columns, Binary.EMPTY_VALUE);
                valueColumns[columnIndex] = columns;
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Data type %s is not supported.", type));
            }
        }
    }

    public abstract List<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> var1);

    public abstract List<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> var1);

    public abstract Tablet convertToTablet();

    static {
        for (int rowCount = 0; rowCount <= CACHED_FULL_ROW_INDEX_LIST_ROW_COUNT_UPPER; ++rowCount) {
            CACHED_FULL_ROW_INDEX_LIST.put(rowCount, IntStream.range(0, rowCount).boxed().collect(Collectors.toList()));
        }
    }
}

