/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner;

import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryPlanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.analyze.Analysis;
import org.apache.iotdb.db.queryengine.plan.optimization.AggregationPushDown;
import org.apache.iotdb.db.queryengine.plan.optimization.PlanOptimizer;
import org.apache.iotdb.db.queryengine.plan.optimization.PredicatePushDown;
import org.apache.iotdb.db.queryengine.plan.planner.LogicalPlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.LogicalQueryPlan;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;

public class LogicalPlanner {
    private final MPPQueryContext context;
    private final List<PlanOptimizer> optimizers = Arrays.asList(new PredicatePushDown(), new AggregationPushDown());

    public LogicalPlanner(MPPQueryContext context) {
        this.context = context;
    }

    public LogicalQueryPlan plan(Analysis analysis) {
        long startTime = System.nanoTime();
        PlanNode rootNode = (PlanNode)new LogicalPlanVisitor(analysis).process(analysis.getStatement(), this.context);
        if (analysis.isQuery()) {
            long planFinishTime = System.nanoTime();
            QueryPlanCostMetricSet.getInstance().recordPlanCost("logical_planner", System.nanoTime() - planFinishTime);
            this.context.setLogicalPlanCost(planFinishTime - startTime);
            for (PlanOptimizer optimizer : this.optimizers) {
                rootNode = optimizer.optimize(rootNode, analysis, this.context);
            }
            this.context.setLogicalOptimizationCost(System.nanoTime() - planFinishTime);
        }
        return new LogicalQueryPlan(this.context, rootNode);
    }
}

