/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.expression.visitor;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.binary.BinaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.queryengine.plan.expression.ternary.TernaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.unary.UnaryExpression;
import org.apache.iotdb.db.queryengine.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.view.visitor.GetSourcePathsVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.view.visitor.TransformToExpressionVisitor;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.schema.IMeasurementSchema;

public class ReplaceLogicalViewVisitor
extends ExpressionVisitor<Expression, List<PartialPath>> {
    private TransformToExpressionVisitor transformToExpressionVisitor = new TransformToExpressionVisitor();
    private GetSourcePathsVisitor getSourcePathsVisitor = new GetSourcePathsVisitor();
    private boolean hasProcessedAggregationFunction = false;
    private List<PartialPath> newAddedPathList = null;

    public ReplaceLogicalViewVisitor() {
        this.resetHadProcessedAggregationFunction();
        this.newAddedPathList = new ArrayList<PartialPath>();
    }

    public Pair<Expression, Boolean> replaceViewInThisExpression(Expression expression) {
        int oldSize = this.newAddedPathList.size();
        Expression result = this.process(expression, this.newAddedPathList);
        int newSize = this.newAddedPathList.size();
        if (oldSize != newSize) {
            return new Pair((Object)result, (Object)true);
        }
        return new Pair((Object)expression, (Object)false);
    }

    public List<PartialPath> getNewAddedPathList() {
        return this.newAddedPathList;
    }

    private Expression transform(ViewExpression viewExpression) {
        return this.transformToExpressionVisitor.process(viewExpression, null);
    }

    private List<PartialPath> collectSourcePaths(ViewExpression viewExpression) {
        return (List)this.getSourcePathsVisitor.process(viewExpression, null);
    }

    public boolean getHadProcessedAggregationFunction() {
        return this.hasProcessedAggregationFunction;
    }

    public void resetHadProcessedAggregationFunction() {
        this.hasProcessedAggregationFunction = false;
    }

    @Override
    public Expression process(Expression expression, List<PartialPath> context) {
        return expression.accept(this, context);
    }

    @Override
    public Expression visitExpression(Expression expression, List<PartialPath> context) {
        return expression;
    }

    @Override
    public Expression visitUnaryExpression(UnaryExpression unaryExpression, List<PartialPath> context) {
        unaryExpression.setExpression(this.process(unaryExpression.getExpression(), context));
        return unaryExpression;
    }

    @Override
    public Expression visitBinaryExpression(BinaryExpression binaryExpression, List<PartialPath> context) {
        binaryExpression.setLeftExpression(this.process(binaryExpression.getLeftExpression(), context));
        binaryExpression.setRightExpression(this.process(binaryExpression.getRightExpression(), context));
        return binaryExpression;
    }

    @Override
    public Expression visitTernaryExpression(TernaryExpression ternaryExpression, List<PartialPath> context) {
        ternaryExpression.setFirstExpression(this.process(ternaryExpression.getFirstExpression(), context));
        ternaryExpression.setSecondExpression(this.process(ternaryExpression.getSecondExpression(), context));
        ternaryExpression.setThirdExpression(this.process(ternaryExpression.getThirdExpression(), context));
        return ternaryExpression;
    }

    @Override
    public Expression visitFunctionExpression(FunctionExpression functionExpression, List<PartialPath> context) {
        List<Expression> children = functionExpression.getExpressions();
        ArrayList<Expression> replacedChildren = new ArrayList<Expression>();
        for (Expression child : children) {
            replacedChildren.add(this.process(child, context));
        }
        functionExpression.setExpressions(replacedChildren);
        if (functionExpression.isAggregationFunctionExpression()) {
            this.hasProcessedAggregationFunction = true;
        }
        return functionExpression;
    }

    @Override
    public Expression visitTimeSeriesOperand(TimeSeriesOperand timeSeriesOperand, List<PartialPath> context) {
        PartialPath path = timeSeriesOperand.getPath();
        try {
            IMeasurementSchema measurementSchema = path.getMeasurementSchema();
            if (measurementSchema.isLogicalView()) {
                ViewExpression viewExpression = ((LogicalViewSchema)measurementSchema).getExpression();
                Expression result = this.transform(viewExpression);
                context.addAll(this.collectSourcePaths(viewExpression));
                return result;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return timeSeriesOperand;
    }
}

