/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.utils;

import java.io.File;
import org.apache.tsfile.utils.FSUtils;
import org.apache.tsfile.utils.Pair;

public class FilePathUtils {
    private static final String LOCAL_PATH_SPLIT_STRING = "\\".equals(File.separator) ? "\\\\" : "/";
    public static final String FILE_NAME_SEPARATOR = "-";

    private FilePathUtils() {
    }

    public static String regularizePath(String filePath) {
        if (filePath.length() > 0 && filePath.charAt(filePath.length() - 1) != File.separatorChar) {
            filePath = filePath + File.separatorChar;
        }
        return filePath;
    }

    public static String[] splitTsFilePath(String tsFileAbsolutePath) {
        String separator = LOCAL_PATH_SPLIT_STRING;
        if (!FSUtils.isLocal(tsFileAbsolutePath)) {
            separator = "/";
        }
        return tsFileAbsolutePath.split(separator);
    }

    public static boolean isSequence(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        if (pathSegments.length < 5) {
            return false;
        }
        return pathSegments[pathSegments.length - 5].equals("sequence");
    }

    public static String getLogicalStorageGroupName(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 4];
    }

    public static String getDataRegionId(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 3];
    }

    public static long getTimePartitionId(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return Long.parseLong(pathSegments[pathSegments.length - 2]);
    }

    public static String getTsFileNameWithoutHardLink(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return pathSegments[pathSegments.length - 1].substring(0, pathSegments[pathSegments.length - 1].lastIndexOf("."));
    }

    public static String getTsFilePrefixPath(String tsFileAbsolutePath) {
        if (tsFileAbsolutePath == null) {
            return null;
        }
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        int pathLength = pathSegments.length;
        return pathSegments[pathLength - 4] + File.separator + pathSegments[pathLength - 3] + File.separator + pathSegments[pathLength - 2];
    }

    public static long splitAndGetTsFileVersion(String tsFileName) {
        String[] names = tsFileName.split(FILE_NAME_SEPARATOR);
        if (names.length != 4) {
            return 0L;
        }
        return Long.parseLong(names[1]);
    }

    public static Pair<String, Long> getLogicalSgNameAndTimePartitionIdPair(String tsFileAbsolutePath) {
        String[] pathSegments = FilePathUtils.splitTsFilePath(tsFileAbsolutePath);
        return new Pair<String, Long>(pathSegments[pathSegments.length - 4], Long.parseLong(pathSegments[pathSegments.length - 2]));
    }
}

