/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.RamUsageEstimator;

public class SchemaQueryOrderByHeatOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(SchemaQueryOrderByHeatOperator.class);
    private final OperatorContext operatorContext;
    private final List<Operator> operators;
    private final List<TsBlock> showTimeSeriesResult;
    private final List<TsBlock> lastQueryResult;
    private final List<TSDataType> outputDataTypes;
    private final int columnCount;
    private final boolean[] noMoreTsBlocks;
    private List<TsBlock> resultTsBlockList;
    private int currentIndex = 0;

    public SchemaQueryOrderByHeatOperator(OperatorContext operatorContext, List<Operator> operators) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.operators = operators;
        this.showTimeSeriesResult = new ArrayList<TsBlock>();
        this.lastQueryResult = new ArrayList<TsBlock>();
        this.outputDataTypes = ColumnHeaderConstant.showTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        this.columnCount = this.outputDataTypes.size();
        this.noMoreTsBlocks = new boolean[operators.size()];
    }

    @Override
    public TsBlock next() throws Exception {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.resultTsBlockList != null) {
            ++this.currentIndex;
            return this.resultTsBlockList.get(this.currentIndex - 1);
        }
        boolean allChildrenReady = true;
        for (int i = 0; i < this.operators.size(); ++i) {
            if (!this.noMoreTsBlocks[i]) {
                TsBlock tsBlock;
                Operator operator = this.operators.get(i);
                if (operator.isFinished()) {
                    this.noMoreTsBlocks[i] = true;
                } else if (operator.hasNextWithTimer() && null != (tsBlock = operator.nextWithTimer()) && !tsBlock.isEmpty()) {
                    if (this.isShowTimeSeriesBlock(tsBlock)) {
                        this.showTimeSeriesResult.add(tsBlock);
                    } else {
                        this.lastQueryResult.add(tsBlock);
                    }
                }
            }
            if (this.noMoreTsBlocks[i]) continue;
            allChildrenReady = false;
        }
        if (allChildrenReady) {
            this.generateResultTsBlockList();
            ++this.currentIndex;
            return this.resultTsBlockList.get(this.currentIndex - 1);
        }
        return null;
    }

    private void generateResultTsBlockList() {
        HashMap<String, Long> timeseriesToLastTimestamp = new HashMap<String, Long>();
        for (TsBlock tsBlock : this.lastQueryResult) {
            for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                String timeseries = tsBlock.getColumn(0).getBinary(i).toString();
                long time2 = tsBlock.getTimeByIndex(i);
                timeseriesToLastTimestamp.put(timeseries, time2);
            }
        }
        HashMap<Long, List> lastTimestampToTsSchema = new HashMap<Long, List>();
        for (TsBlock tsBlock : this.showTimeSeriesResult) {
            TsBlock.TsBlockRowIterator tsBlockRowIterator = tsBlock.getTsBlockRowIterator();
            while (tsBlockRowIterator.hasNext()) {
                Object[] line = tsBlockRowIterator.next();
                String timeseries = line[0].toString();
                long time3 = timeseriesToLastTimestamp.getOrDefault(timeseries, 0L);
                lastTimestampToTsSchema.computeIfAbsent(time3, key -> new ArrayList()).add(line);
            }
        }
        ArrayList arrayList = new ArrayList(lastTimestampToTsSchema.keySet());
        arrayList.sort(Comparator.reverseOrder());
        this.resultTsBlockList = SchemaTsBlockUtil.transferSchemaResultToTsBlockList(arrayList.iterator(), this.outputDataTypes, (time, tsBlockBuilder) -> {
            List rows = (List)lastTimestampToTsSchema.get(time);
            for (Object[] row : rows) {
                tsBlockBuilder.getTimeColumnBuilder().writeLong(0L);
                for (int i = 0; i < this.columnCount; ++i) {
                    Object value = row[i];
                    if (null == value) {
                        tsBlockBuilder.getColumnBuilder(i).appendNull();
                        continue;
                    }
                    tsBlockBuilder.getColumnBuilder(i).writeBinary(new Binary(value.toString(), TSFileConfig.STRING_CHARSET));
                }
                tsBlockBuilder.declarePosition();
            }
        });
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        ArrayList listenableFutureList = new ArrayList(this.operators.size());
        for (int i = 0; i < this.operators.size(); ++i) {
            ListenableFuture<?> isBlocked;
            if (this.noMoreTsBlocks[i] || (isBlocked = this.operators.get(i).isBlocked()).isDone()) continue;
            listenableFutureList.add(isBlocked);
        }
        return listenableFutureList.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutureList);
    }

    private boolean isShowTimeSeriesBlock(TsBlock tsBlock) {
        return tsBlock.getValueColumnCount() == this.columnCount;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.resultTsBlockList == null || this.currentIndex < this.resultTsBlockList.size();
    }

    @Override
    public void close() throws Exception {
        for (Operator operator : this.operators) {
            operator.close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        return !this.hasNextWithTimer();
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        for (Operator child : this.operators) {
            maxPeekMemory += child.calculateMaxReturnSize();
        }
        for (Operator child : this.operators) {
            maxPeekMemory = Math.max(maxPeekMemory, child.calculateMaxPeekMemory());
        }
        return maxPeekMemory;
    }

    @Override
    public long calculateMaxReturnSize() {
        long maxReturnSize = 0L;
        for (Operator child : this.operators) {
            maxReturnSize += child.calculateMaxReturnSize();
        }
        return maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long retainedSize = 0L;
        for (Operator child : this.operators) {
            retainedSize += child.calculateMaxReturnSize();
        }
        for (Operator child : this.operators) {
            retainedSize += child.calculateRetainedSizeAfterCallingNext();
        }
        return retainedSize;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.operators.stream().mapToLong(Accountable::ramBytesUsed).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.noMoreTsBlocks);
    }
}

