/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.ReflectionUtilsApi;
import com.azure.core.implementation.ReflectionUtilsClassic;
import com.azure.core.implementation.ReflectionUtilsMethodHandle;
import com.azure.core.implementation.ReflectiveInvoker;
import com.azure.core.util.logging.ClientLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class ReflectionUtils {
    private static final ClientLogger LOGGER;
    private static final ReflectionUtilsApi INSTANCE;

    public static ReflectiveInvoker getMethodInvoker(Class<?> targetClass, Method method) throws Exception {
        return ReflectionUtils.getMethodInvoker(targetClass, method, true);
    }

    public static ReflectiveInvoker getMethodInvoker(Class<?> targetClass, Method method, boolean scopeToAzureCore) throws Exception {
        if (method == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'method' cannot be null."));
        }
        targetClass = targetClass == null ? method.getDeclaringClass() : targetClass;
        return INSTANCE.getMethodInvoker(targetClass, method, scopeToAzureCore);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> targetClass, Constructor<?> constructor) throws Exception {
        return ReflectionUtils.getConstructorInvoker(targetClass, constructor, true);
    }

    public static ReflectiveInvoker getConstructorInvoker(Class<?> targetClass, Constructor<?> constructor, boolean scopeToAzureCore) throws Exception {
        if (constructor == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'constructor' cannot be null."));
        }
        targetClass = targetClass == null ? constructor.getDeclaringClass() : targetClass;
        return INSTANCE.getConstructorInvoker(targetClass, constructor, scopeToAzureCore);
    }

    public static boolean isModuleBased() {
        return INSTANCE.isModuleBased();
    }

    public static ReflectiveInvoker createNoOpInvoker() {
        return new NoOpReflectiveInvoker();
    }

    ReflectionUtils() {
    }

    static {
        ReflectionUtilsApi instance;
        LOGGER = new ClientLogger(ReflectionUtils.class);
        try {
            LOGGER.verbose("Attempting to use java.lang.invoke package to handle reflection.");
            instance = new ReflectionUtilsMethodHandle();
            LOGGER.verbose("Successfully used java.lang.invoke package to handle reflection.");
        }
        catch (LinkageError ignored) {
            LOGGER.verbose("Failed to use java.lang.invoke package to handle reflection. Falling back to java.lang.reflect package to handle reflection.");
            instance = new ReflectionUtilsClassic();
            LOGGER.verbose("Successfully used java.lang.reflect package to handle reflection.");
        }
        INSTANCE = instance;
    }

    private static final class NoOpReflectiveInvoker
    implements ReflectiveInvoker {
        private NoOpReflectiveInvoker() {
        }

        @Override
        public Object invokeStatic(Object ... args) {
            return null;
        }

        @Override
        public Object invokeWithArguments(Object target, Object ... args) {
            return null;
        }

        @Override
        public int getParameterCount() {
            return 0;
        }
    }
}

