/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.impl.wrappers.ContextualRunnable;

public final class ContextualRunnableN
implements ContextualRunnable {
    private ThreadLocal<Object>[] tl;
    private Object[] state;
    private final Runnable runnable;

    public ContextualRunnableN(Runnable runnable, int n) {
        this.runnable = runnable;
        this.tl = new ThreadLocal[n];
        this.state = new Object[n];
    }

    @Override
    public void run() {
        int i;
        Object[] moved = new Object[this.tl.length];
        for (i = 0; i < this.tl.length; ++i) {
            moved[i] = this.tl[i].get();
            this.tl[i].set(this.state[i]);
        }
        try {
            this.runnable.run();
        }
        finally {
            for (i = 0; i < this.tl.length; ++i) {
                this.tl[i].set(moved[i]);
            }
        }
    }

    @Override
    public void captureThreadLocal(int index, ThreadLocal<Object> threadLocal, Object value) {
        if (index < 0 || index >= this.state.length) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        this.tl[index] = threadLocal;
        this.state[index] = value;
    }
}

