/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.admin;

import jakarta.annotation.Priority;
import jakarta.decorator.Decorator;
import jakarta.decorator.Delegate;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.polaris.core.admin.model.CreatePrincipalRequest;
import org.apache.polaris.core.admin.model.GrantPrincipalRoleRequest;
import org.apache.polaris.core.admin.model.UpdatePrincipalRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.admin.api.PolarisPrincipalsApiService;

@Decorator
@Priority(value=1000)
public class PolarisPrincipalsEventServiceDelegator
implements PolarisPrincipalsApiService {
    @Inject
    @Delegate
    PolarisPrincipalsApiService delegate;

    public Response createPrincipal(CreatePrincipalRequest request, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.createPrincipal(request, realmContext, securityContext);
    }

    public Response deletePrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.deletePrincipal(principalName, realmContext, securityContext);
    }

    public Response getPrincipal(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.getPrincipal(principalName, realmContext, securityContext);
    }

    public Response updatePrincipal(String principalName, UpdatePrincipalRequest updateRequest, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.updatePrincipal(principalName, updateRequest, realmContext, securityContext);
    }

    public Response rotateCredentials(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.rotateCredentials(principalName, realmContext, securityContext);
    }

    public Response listPrincipals(RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listPrincipals(realmContext, securityContext);
    }

    public Response assignPrincipalRole(String principalName, GrantPrincipalRoleRequest request, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.assignPrincipalRole(principalName, request, realmContext, securityContext);
    }

    public Response revokePrincipalRole(String principalName, String principalRoleName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.revokePrincipalRole(principalName, principalRoleName, realmContext, securityContext);
    }

    public Response listPrincipalRolesAssigned(String principalName, RealmContext realmContext, SecurityContext securityContext) {
        return this.delegate.listPrincipalRolesAssigned(principalName, realmContext, securityContext);
    }
}

