/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.io.writer.SetTreeNode;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.OptimizingExecutor;
import org.apache.amoro.optimizing.OptimizingTaskSummary;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.optimizing.RewriteFilesOutput;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileWriter;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRewriteFilesExecutor
implements OptimizingExecutor<RewriteFilesOutput> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRewriteFilesExecutor.class);
    protected final RewriteFilesInput input;
    protected MixedTable table;
    protected OptimizingDataReader dataReader;
    protected AuthenticatedFileIO io;
    protected StructLikeCollections structLikeCollections;

    public AbstractRewriteFilesExecutor(RewriteFilesInput input, MixedTable table, StructLikeCollections structLikeCollections) {
        this.input = input;
        this.table = table;
        this.io = table.io();
        this.structLikeCollections = structLikeCollections;
        this.dataReader = this.dataReader();
    }

    protected abstract OptimizingDataReader dataReader();

    protected abstract FileWriter<PositionDelete<Record>, DeleteWriteResult> posWriter();

    protected abstract TaskWriter<Record> dataWriter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RewriteFilesOutput execute() {
        LOG.info("Start processing table optimize task: {}", (Object)this.input);
        ArrayList<DataFile> dataFiles = new ArrayList();
        ArrayList<DeleteFile> deleteFiles = new ArrayList();
        long startTime = System.currentTimeMillis();
        try {
            if (!ArrayUtils.isEmpty((Object[])this.input.rePosDeletedDataFiles())) {
                deleteFiles = this.io.doAs(this::equalityToPosition);
            }
            if (!ArrayUtils.isEmpty((Object[])this.input.rewrittenDataFiles())) {
                dataFiles = this.io.doAs(this::rewriterDataFiles);
            }
        }
        finally {
            this.dataReader.close();
        }
        long duration = System.currentTimeMillis() - startTime;
        Map<String, String> summary = this.resolverSummary(dataFiles, deleteFiles, duration);
        return new RewriteFilesOutput(dataFiles.toArray(new DataFile[0]), deleteFiles.toArray(new DeleteFile[0]), summary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DeleteFile> equalityToPosition() throws Exception {
        try (FileWriter<PositionDelete<Record>, DeleteWriteResult> posDeleteWriter = this.posWriter();
             CloseableIterator iterator = this.dataReader.readDeletedData().iterator();){
            PositionDelete positionDelete = PositionDelete.create();
            while (iterator.hasNext()) {
                Record record = (Record)iterator.next();
                String filePath = (String)record.getField(MetadataColumns.FILE_PATH.name());
                Long rowPosition = (Long)record.getField(MetadataColumns.ROW_POSITION.name());
                positionDelete.set((CharSequence)filePath, rowPosition.longValue(), null);
                if (posDeleteWriter instanceof SetTreeNode) {
                    DataTreeNode dataTreeNode = DataTreeNode.ofId((Long)record.getField("_tree_node"));
                    ((SetTreeNode)posDeleteWriter).setTreeNode(dataTreeNode);
                }
                posDeleteWriter.write((Object)positionDelete);
            }
        }
        return ((DeleteWriteResult)posDeleteWriter.result()).deleteFiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataFile> rewriterDataFiles() throws Exception {
        ArrayList result = Lists.newArrayList();
        try (TaskWriter<Record> writer = this.dataWriter();
             CloseableIterator records = this.dataReader.readData().iterator();){
            while (records.hasNext()) {
                Record record = (Record)records.next();
                writer.write((Object)record);
            }
        }
        result.addAll(Arrays.asList(writer.dataFiles()));
        return result;
    }

    protected FileFormat dataFileFormat() {
        String formatAsString = this.table.properties().getOrDefault("write.format.default", "parquet");
        return FileFormat.valueOf((String)formatAsString.toUpperCase());
    }

    protected FileFormat deleteFileFormat() {
        String deleteFileFormatName = this.table.properties().getOrDefault("write.delete.format.default", "parquet");
        return FileFormat.valueOf((String)deleteFileFormatName.toUpperCase());
    }

    protected FileAppenderFactory<Record> fullMetricAppenderFactory(PartitionSpec spec) {
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), spec);
        appenderFactory.setAll(this.table.properties());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_PATH.name(), MetricsModes.Full.get().toString());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_POS.name(), MetricsModes.Full.get().toString());
        return appenderFactory;
    }

    protected long targetSize() {
        return PropertyUtil.propertyAsLong(this.table.properties(), (String)"self-optimizing.target-size", (long)0x8000000L);
    }

    protected StructLike partition() {
        ContentFile<?>[] dataFiles = this.input.allFiles();
        return dataFiles[0].partition();
    }

    protected EncryptionManager encryptionManager() {
        if (this.table.isKeyedTable()) {
            return this.table.asKeyedTable().baseTable().encryption();
        }
        return this.table.asUnkeyedTable().encryption();
    }

    private Map<String, String> resolverSummary(List<DataFile> dataFiles, List<DeleteFile> deleteFiles, long duration) {
        int dataFileCnt = 0;
        long dataFileTotalSize = 0L;
        int eqDeleteFileCnt = 0;
        long eqDeleteFileTotalSize = 0L;
        int posDeleteFileCnt = 0;
        long posDeleteFileTotalSize = 0L;
        if (dataFiles != null) {
            for (DataFile dataFile : dataFiles) {
                ++dataFileCnt;
                dataFileTotalSize += dataFile.fileSizeInBytes();
            }
        }
        if (deleteFiles != null) {
            for (DeleteFile deleteFile : deleteFiles) {
                if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
                    ++eqDeleteFileCnt;
                    eqDeleteFileTotalSize += deleteFile.fileSizeInBytes();
                    continue;
                }
                ++posDeleteFileCnt;
                posDeleteFileTotalSize += deleteFile.fileSizeInBytes();
            }
        }
        OptimizingTaskSummary summary = new OptimizingTaskSummary();
        summary.setDataFileCnt(dataFileCnt);
        summary.setDataFileTotalSize(dataFileTotalSize);
        summary.setEqDeleteFileCnt(eqDeleteFileCnt);
        summary.setEqDeleteFileTotalSize(eqDeleteFileTotalSize);
        summary.setPosDeleteFileCnt(posDeleteFileCnt);
        summary.setPosDeleteFileTotalSize(posDeleteFileTotalSize);
        summary.setExecuteDuration(duration);
        return summary.getSummary();
    }
}

