/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.internal;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.server.persistence.PersistentBase;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.utils.InternalTableUtil;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.LocationProviders;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.io.OutputFile;

public class IcebergInternalTableOperations
extends PersistentBase
implements TableOperations {
    private final ServerTableIdentifier identifier;
    private org.apache.iceberg.TableMetadata current;
    private final FileIO io;
    private TableMetadata tableMetadata;

    public IcebergInternalTableOperations(ServerTableIdentifier identifier, TableMetadata tableMetadata, FileIO io) {
        this.io = io;
        this.tableMetadata = tableMetadata;
        this.identifier = identifier;
    }

    public org.apache.iceberg.TableMetadata current() {
        if (this.current == null) {
            this.refresh();
        }
        return this.current;
    }

    public org.apache.iceberg.TableMetadata refresh() {
        if (this.tableMetadata == null) {
            this.tableMetadata = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaById(this.identifier.getId()));
        }
        if (this.tableMetadata == null) {
            return null;
        }
        String metadataFileLocation = this.tableMetadataLocation(this.tableMetadata);
        if (StringUtils.isBlank((CharSequence)metadataFileLocation)) {
            return null;
        }
        this.current = TableMetadataParser.read((FileIO)this.io, (String)metadataFileLocation);
        return this.current;
    }

    protected String tableMetadataLocation(TableMetadata tableMeta) {
        return tableMeta.getProperties().get("iceberg.metadata.location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(org.apache.iceberg.TableMetadata base, org.apache.iceberg.TableMetadata metadata) {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"Invalid table metadata for create transaction, base is null");
        Preconditions.checkArgument((metadata != null ? 1 : 0) != 0, (Object)"Invalid table metadata for create transaction, new metadata is null");
        if (base != this.current()) {
            throw new CommitFailedException("Cannot commit: stale table metadata", new Object[0]);
        }
        String newMetadataFileLocation = InternalTableUtil.genNewMetadataFileLocation(base, metadata);
        try {
            this.commitTableInternal(this.tableMetadata, base, metadata, newMetadataFileLocation);
            TableMetadata updatedMetadata = this.doCommit();
            this.checkCommitSuccess(updatedMetadata, newMetadataFileLocation);
        }
        catch (Exception e) {
            this.io.deleteFile(newMetadataFileLocation);
        }
        finally {
            this.tableMetadata = null;
        }
        this.refresh();
    }

    public FileIO io() {
        return this.io;
    }

    public String metadataFileLocation(String fileName) {
        return InternalTableUtil.genMetadataFileLocation(this.current(), fileName);
    }

    public LocationProvider locationProvider() {
        return LocationProviders.locationsFor((String)this.current().location(), (Map)this.current().properties());
    }

    public TableOperations temp(org.apache.iceberg.TableMetadata uncommittedMetadata) {
        return super.temp(uncommittedMetadata);
    }

    private TableMetadata doCommit() {
        ServerTableIdentifier tableIdentifier = this.tableMetadata.getTableIdentifier();
        AtomicInteger effectRows = new AtomicInteger();
        AtomicReference metadataRef = new AtomicReference();
        this.doAsTransaction(() -> {
            int effects = this.getAs(TableMetaMapper.class, mapper -> mapper.commitTableChange(tableIdentifier.getId(), this.tableMetadata));
            effectRows.set(effects);
        }, () -> {
            TableMetadata m = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaById(tableIdentifier.getId()));
            metadataRef.set(m);
        });
        if (effectRows.get() == 0) {
            throw new CommitFailedException("commit failed for version: " + this.tableMetadata.getMetaVersion() + " has been committed", new Object[0]);
        }
        return (TableMetadata)metadataRef.get();
    }

    private void commitTableInternal(TableMetadata amsTableMetadata, org.apache.iceberg.TableMetadata base, org.apache.iceberg.TableMetadata newMetadata, String newMetadataFileLocation) {
        if (!Objects.equals(newMetadata.location(), base.location())) {
            throw new UnsupportedOperationException("SetLocation is not supported.");
        }
        OutputFile outputFile = this.io.newOutputFile(newMetadataFileLocation);
        TableMetadataParser.overwrite((org.apache.iceberg.TableMetadata)newMetadata, (OutputFile)outputFile);
        this.updateMetadataLocationProperties(amsTableMetadata, base.metadataFileLocation(), newMetadataFileLocation);
    }

    protected void updateMetadataLocationProperties(TableMetadata amsTableMetadata, String oldMetadataFileLocation, String newMetadataFileLocation) {
        Map<String, String> properties = amsTableMetadata.getProperties();
        properties.put("iceberg.metadata.prev-location", oldMetadataFileLocation);
        properties.put("iceberg.metadata.location", newMetadataFileLocation);
        amsTableMetadata.setProperties(properties);
    }

    private void checkCommitSuccess(TableMetadata updatedTableMetadata, String metadataFileLocation) {
        String metaLocationInDatabase = this.tableMetadataLocation(updatedTableMetadata);
        if (!Objects.equals(metaLocationInDatabase, metadataFileLocation)) {
            throw new CommitFailedException("commit conflict, some other commit happened during this commit. ", new Object[0]);
        }
    }
}

