/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.manager;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.amoro.resource.Resource;
import org.apache.amoro.server.manager.AbstractResourceContainer;
import org.apache.amoro.shade.guava32.com.google.common.base.Function;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class SparkOptimizerContainer
extends AbstractResourceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(SparkOptimizerContainer.class);
    public static final String SPARK_HOME_PROPERTY = "spark-home";
    public static final String ENV_HADOOP_USER_NAME = "HADOOP_USER_NAME";
    private static final String DEFAULT_JOB_URI = "/plugin/optimizer/spark/optimizer-job.jar";
    private static final String SPARK_JOB_MAIN_CLASS = "org.apache.amoro.optimizer.spark.SparkOptimizer";
    public static final String SPARK_MASTER = "master";
    public static final String SPARK_DEPLOY_MODE = "deploy-mode";
    public static final String SPARK_JOB_URI = "job-uri";
    public static final String YARN_APPLICATION_ID_PROPERTY = "yarn-application-id";
    public static final String KUBERNETES_SUBMISSION_ID_PROPERTY = "kubernetes-submission-id";
    private static final Pattern APPLICATION_ID_PATTERN = Pattern.compile("(.*)application_(\\d+)_(\\d+)");
    private static final int MAX_READ_APP_ID_TIME = 600000;
    private static final Function<String, String> yarnApplicationIdReader = readLine -> {
        Matcher matcher = APPLICATION_ID_PATTERN.matcher((CharSequence)readLine);
        if (matcher.matches()) {
            return String.format("application_%s_%s", matcher.group(2), matcher.group(3));
        }
        return null;
    };
    private String sparkMaster;
    private DeployMode deployMode;
    private String sparkHome;
    private String jobUri;

    @Override
    public void init(String name, Map<String, String> containerProperties) {
        super.init(name, containerProperties);
        this.sparkHome = this.getSparkHome();
        this.sparkMaster = containerProperties.getOrDefault(SPARK_MASTER, "yarn");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)this.sparkMaster), (String)"The property: %s is required", (Object)this.sparkMaster);
        String runMode = Optional.ofNullable(containerProperties.get(SPARK_DEPLOY_MODE)).orElse(DeployMode.CLIENT.getValue());
        this.deployMode = DeployMode.valueToEnum(runMode);
        String jobUri = containerProperties.get(SPARK_JOB_URI);
        if (this.deployMode.equals(DeployMode.CLUSTER.name())) {
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)jobUri), (String)"The property: %s is required if running mode in cluster mode.", (Object)SPARK_JOB_URI);
        }
        if (StringUtils.isEmpty((CharSequence)jobUri)) {
            jobUri = this.amsHome + DEFAULT_JOB_URI;
        }
        this.jobUri = jobUri;
        SparkConf sparkConf = SparkConf.buildFor(this.loadSparkConfig(), containerProperties).build();
        if (this.deployedOnKubernetes()) {
            String imageRef = sparkConf.configValue("spark.kubernetes.container.image");
            Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)imageRef), (String)"The spark-conf: %s is required if running mode is %s", (Object)"spark.kubernetes.container.image", (Object)this.deployMode.getValue());
        }
    }

    @Override
    protected Map<String, String> doScaleOut(Resource resource) {
        String startUpArgs = this.buildOptimizerStartupArgsString(resource);
        try {
            String exportCmd = String.join((CharSequence)" && ", this.exportSystemProperties());
            String startUpCmd = String.format("%s && %s", exportCmd, startUpArgs);
            String[] cmd = new String[]{"/bin/sh", "-c", startUpCmd};
            LOG.info("Starting spark optimizer using command : {}", (Object)startUpCmd);
            Process exec = Runtime.getRuntime().exec(cmd);
            HashMap startUpStatesMap = Maps.newHashMap();
            if (this.deployedOnKubernetes()) {
                SparkConf sparkConf = SparkConf.buildFor(this.loadSparkConfig(), this.getContainerProperties()).withGroupProperties(resource.getProperties()).build();
                String namespace = (String)StringUtils.defaultIfEmpty((CharSequence)sparkConf.configValue("spark.kubernetes.namespace"), (CharSequence)"default");
                startUpStatesMap.put(KUBERNETES_SUBMISSION_ID_PROPERTY, String.format("%s:%s", namespace, this.kubernetesDriverName(resource)));
            } else {
                String applicationId = this.fetchCommandOutput(exec, yarnApplicationIdReader);
                if (applicationId != null) {
                    startUpStatesMap.put(YARN_APPLICATION_ID_PROPERTY, applicationId);
                }
            }
            return startUpStatesMap;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to scale out spark optimizer.", e);
        }
    }

    @Override
    protected String buildOptimizerStartupArgsString(Resource resource) {
        Map<String, String> sparkConfig = this.loadSparkConfig();
        SparkConf resourceSparkConf = SparkConf.buildFor(sparkConfig, this.getContainerProperties()).withGroupProperties(resource.getProperties()).build();
        resourceSparkConf.putToOptions("spark.dynamicAllocation.enabled", (String)StringUtils.defaultIfEmpty((CharSequence)resourceSparkConf.configValue("spark.dynamicAllocation.enabled"), (CharSequence)"true"));
        resourceSparkConf.putToOptions("spark.dynamicAllocation.maxExecutors", (String)StringUtils.defaultIfEmpty((CharSequence)resourceSparkConf.configValue("spark.dynamicAllocation.maxExecutors"), (CharSequence)String.valueOf(resource.getThreadCount())));
        if (this.deployedOnKubernetes()) {
            this.addKubernetesProperties(resource, resourceSparkConf);
        }
        String sparkOptions = resourceSparkConf.toConfOptions();
        String proxyUser = this.getContainerProperties().getOrDefault("export.HADOOP_USER_NAME", "hadoop");
        String jobArgs = super.buildOptimizerStartupArgsString(resource);
        return String.format("%s/bin/spark-submit --master %s --deploy-mode=%s %s --proxy-user %s --class %s %s %s", this.sparkHome, this.sparkMaster, this.deployMode.getValue(), sparkOptions, proxyUser, SPARK_JOB_MAIN_CLASS, this.jobUri, jobArgs);
    }

    private Map<String, String> loadSparkConfig() {
        try {
            return Arrays.stream(new org.apache.spark.SparkConf().getAll()).collect(Collectors.toMap(Tuple2::_1, Tuple2::_2));
        }
        catch (Exception e) {
            LOG.error("Load spark conf failed.", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    private boolean deployedOnKubernetes() {
        return this.sparkMaster.startsWith("k8s://");
    }

    private void addKubernetesProperties(Resource resource, SparkConf sparkConf) {
        String driverName = this.kubernetesDriverName(resource);
        sparkConf.putToOptions("spark.kubernetes.driver.pod.name", driverName);
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-group", resource.getGroupName());
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-implementation", "spark-native-kubernetes");
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-id", resource.getResourceId());
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-group", resource.getGroupName());
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-implementation", "spark-native-kubernetes");
        sparkConf.putToOptions("spark.kubernetes.driver.label.optimizer-id", resource.getResourceId());
    }

    /*
     * Exception decompiling
     */
    private <T> T fetchCommandOutput(Process exec, Function<String, T> commandReader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseOptimizer(Resource resource) {
        String releaseCommand = this.deployedOnKubernetes() ? this.buildReleaseKubernetesCommand(resource) : this.buildReleaseYarnCommand(resource);
        try {
            String exportCmd = String.join((CharSequence)" && ", this.exportSystemProperties());
            String releaseCmd = exportCmd + " && " + releaseCommand;
            String[] cmd = new String[]{"/bin/sh", "-c", releaseCmd};
            LOG.info("Releasing spark optimizer using command: {}", (Object)releaseCmd);
            Runtime.getRuntime().exec(cmd);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to release spark optimizer.", e);
        }
    }

    private String buildReleaseYarnCommand(Resource resource) {
        Preconditions.checkArgument((boolean)resource.getProperties().containsKey(YARN_APPLICATION_ID_PROPERTY), (String)"Cannot find {} from optimizer start up stats", (Object)YARN_APPLICATION_ID_PROPERTY);
        String applicationId = (String)resource.getProperties().get(YARN_APPLICATION_ID_PROPERTY);
        return String.format("%s/bin/spark-submit --kill %s --master %s", this.sparkHome, applicationId, this.sparkMaster);
    }

    private String buildReleaseKubernetesCommand(Resource resource) {
        Map<String, String> sparkConfig = this.loadSparkConfig();
        Preconditions.checkArgument((boolean)resource.getProperties().containsKey(KUBERNETES_SUBMISSION_ID_PROPERTY), (String)"Cannot find {} from optimizer start up stats.", (Object)KUBERNETES_SUBMISSION_ID_PROPERTY);
        SparkConf resourceSparkConf = SparkConf.buildFor(sparkConfig, this.getContainerProperties()).withGroupProperties(resource.getProperties()).build();
        String sparkOptions = resourceSparkConf.toConfOptions();
        String submissionId = (String)resource.getProperties().get(KUBERNETES_SUBMISSION_ID_PROPERTY);
        return String.format("%s/bin/spark-submit --kill %s --master %s %s", this.sparkHome, submissionId, this.sparkMaster, sparkOptions);
    }

    private String getSparkHome() {
        String sparkHome = this.getContainerProperties().get(SPARK_HOME_PROPERTY);
        Preconditions.checkNotNull((Object)sparkHome, (String)"Container property: %s is required", (Object)SPARK_HOME_PROPERTY);
        return sparkHome.replaceAll("/$", "");
    }

    private String kubernetesDriverName(Resource resource) {
        return "amoro-optimizer-" + resource.getResourceId();
    }

    public static class SparkConf {
        public static final String SPARK_PARAMETER_PREFIX = "spark-conf.";
        final Map<String, String> sparkConf;
        final Map<String, String> sparkOptions;

        public SparkConf(Map<String, String> sparkConf, Map<String, String> sparkOptions) {
            this.sparkConf = sparkConf;
            this.sparkOptions = sparkOptions;
        }

        public String configValue(String key) {
            if (this.sparkOptions.containsKey(key)) {
                return this.sparkOptions.get(key);
            }
            return this.sparkConf.get(key);
        }

        public void putToOptions(String key, String value) {
            this.sparkOptions.put(key, value);
        }

        public String toConfOptions() {
            return this.sparkOptions.entrySet().stream().map(entry -> "--conf " + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" "));
        }

        public static Builder buildFor(Map<String, String> sparkConf, Map<String, String> containerProperties) {
            return new Builder(sparkConf, containerProperties);
        }

        public static class Builder {
            final Map<String, String> sparkConf;
            Map<String, String> containerProperties;
            Map<String, String> groupProperties = Collections.emptyMap();

            public Builder(Map<String, String> sparkConf, Map<String, String> containerProperties) {
                this.sparkConf = Maps.newHashMap(sparkConf);
                this.containerProperties = containerProperties == null ? Collections.emptyMap() : containerProperties;
            }

            public Builder withGroupProperties(Map<String, String> groupProperties) {
                this.groupProperties = groupProperties;
                return this;
            }

            public SparkConf build() {
                HashMap options = Maps.newHashMap();
                this.containerProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SparkConf.SPARK_PARAMETER_PREFIX)).forEach(entry -> {
                    String cfr_ignored_0 = (String)options.put(((String)entry.getKey()).substring(SparkConf.SPARK_PARAMETER_PREFIX.length()), entry.getValue());
                });
                this.groupProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(SparkConf.SPARK_PARAMETER_PREFIX)).forEach(entry -> {
                    String cfr_ignored_0 = (String)options.put(((String)entry.getKey()).substring(SparkConf.SPARK_PARAMETER_PREFIX.length()), entry.getValue());
                });
                return new SparkConf(this.sparkConf, options);
            }
        }
    }

    public static class SparkConfKeys {
        public static final String KUBERNETES_IMAGE_REF = "spark.kubernetes.container.image";
        public static final String KUBERNETES_DRIVER_NAME = "spark.kubernetes.driver.pod.name";
        public static final String KUBERNETES_NAMESPACE = "spark.kubernetes.namespace";
        public static final String KUBERNETES_EXECUTOR_LABEL_PREFIX = "spark.kubernetes.driver.label.";
        public static final String KUBERNETES_DRIVER_LABEL_PREFIX = "spark.kubernetes.driver.label.";
        public static final String KUBERNETES_DRA_ENABLED = "spark.dynamicAllocation.enabled";
        public static final String KUBERNETES_DRA_MAX_EXECUTORS = "spark.dynamicAllocation.maxExecutors";
    }

    private static enum DeployMode {
        CLIENT("client"),
        CLUSTER("cluster");

        private final String value;

        private DeployMode(String value) {
            this.value = value;
        }

        public static DeployMode valueToEnum(String value) {
            return Arrays.stream(DeployMode.values()).filter(t -> t.value.equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("can't parse value: " + value));
        }

        public String getValue() {
            return this.value;
        }
    }
}

