/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CrawlerState {
    READY("READY"),
    RUNNING("RUNNING"),
    STOPPING("STOPPING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CrawlerState> VALUE_MAP;
    private final String value;

    private CrawlerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CrawlerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CrawlerState> knownValues() {
        EnumSet<CrawlerState> knownValues = EnumSet.allOf(CrawlerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CrawlerState.class, CrawlerState::toString);
    }
}

