/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.util;

import java.util.List;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.CatalogManager;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;

public class SparkUtil {
    public static TableCatalogAndIdentifier catalogAndIdentifier(SparkSession spark, List<String> nameParts, TableCatalog defaultCatalog) {
        CatalogManager catalogManager = spark.sessionState().catalogManager();
        String[] currentNamespace = defaultCatalog.equals(catalogManager.currentCatalog()) ? catalogManager.currentNamespace() : defaultCatalog.defaultNamespace();
        Preconditions.checkArgument((!nameParts.isEmpty() ? 1 : 0) != 0, (Object)"Cannot determine catalog and identifier from empty name");
        int lastElementIndex = nameParts.size() - 1;
        String name = nameParts.get(lastElementIndex);
        if (nameParts.size() == 1) {
            return new TableCatalogAndIdentifier(defaultCatalog, Identifier.of((String[])currentNamespace, (String)name));
        }
        CatalogPlugin catalogPlugin = null;
        try {
            catalogPlugin = catalogManager.catalog(nameParts.get(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (catalogPlugin == null) {
            String[] namespace = nameParts.subList(0, lastElementIndex).toArray(new String[0]);
            return new TableCatalogAndIdentifier(defaultCatalog, Identifier.of((String[])namespace, (String)name));
        }
        TableCatalog tableCatalog = (TableCatalog)catalogPlugin;
        String[] namespace = nameParts.subList(1, lastElementIndex).toArray(new String[0]);
        return new TableCatalogAndIdentifier(tableCatalog, Identifier.of((String[])namespace, (String)name));
    }

    public static class TableCatalogAndIdentifier {
        TableCatalog tableCatalog;
        Identifier identifier;

        public TableCatalogAndIdentifier(TableCatalog tableCatalog, Identifier identifier) {
            this.tableCatalog = tableCatalog;
            this.identifier = identifier;
        }

        public TableCatalog catalog() {
            return this.tableCatalog;
        }

        public Identifier identifier() {
            return this.identifier;
        }
    }
}

