/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.shade.jackson2.com.fasterxml.jackson.dataformat.csv.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.io.CharTypes;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.io.IOContext;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.core.io.NumberOutput;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.dataformat.csv.CsvSchema;
import org.apache.amoro.shade.jackson2.com.fasterxml.jackson.dataformat.csv.impl.BufferedValue;

public class CsvEncoder {
    private static final int[] sOutputEscapes = new int[0];
    protected static final char[] HEX_CHARS = CharTypes.copyHexChars();
    protected static final int SHORT_WRITE = 32;
    protected static final int MAX_QUOTE_CHECK = 24;
    protected final BufferedValue[] NO_BUFFERED = new BufferedValue[0];
    private static final char[] TRUE_CHARS = "true".toCharArray();
    private static final char[] FALSE_CHARS = "false".toCharArray();
    protected int[] _outputEscapes = sOutputEscapes;
    protected final IOContext _ioContext;
    protected final Writer _out;
    protected final char _cfgColumnSeparator;
    protected final int _cfgQuoteCharacter;
    protected final int _cfgEscapeCharacter;
    protected final char[] _cfgLineSeparator;
    protected final char[] _cfgNullValue;
    protected final int _cfgLineSeparatorLength;
    protected final int _cfgMaxQuoteCheckChars;
    protected final int _cfgMinSafeChar;
    protected int _csvFeatures;
    protected boolean _cfgOptimalQuoting;
    protected final boolean _cfgAllowsComments;
    protected boolean _cfgIncludeMissingTail;
    protected boolean _cfgAlwaysQuoteStrings;
    protected boolean _cfgAlwaysQuoteEmptyStrings;
    protected boolean _cfgEscapeQuoteCharWithEscapeChar;
    protected boolean _cfgEscapeControlCharWithEscapeChar;
    protected boolean _cfgUseFastDoubleWriter;
    protected final char _cfgQuoteCharEscapeChar;
    protected final char _cfgControlCharEscapeChar;
    protected int _columnCount;
    protected int _nextColumnToWrite = 0;
    protected BufferedValue[] _buffered = this.NO_BUFFERED;
    protected int _lastBuffered = -1;
    protected char[] _outputBuffer;
    protected boolean _bufferRecyclable;
    protected int _outputTail = 0;
    protected final int _outputEnd;
    protected int _charsWritten;

    @Deprecated
    public CsvEncoder(IOContext ctxt, int csvFeatures, Writer out, CsvSchema schema) {
        this(ctxt, csvFeatures, out, schema, false);
    }

    public CsvEncoder(IOContext ctxt, int csvFeatures, Writer out, CsvSchema schema, boolean useFastDoubleWriter) {
        this._ioContext = ctxt;
        this._csvFeatures = csvFeatures;
        this._cfgUseFastDoubleWriter = useFastDoubleWriter;
        this._cfgOptimalQuoting = CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING.enabledIn(csvFeatures);
        this._cfgIncludeMissingTail = !CsvGenerator.Feature.OMIT_MISSING_TAIL_COLUMNS.enabledIn(this._csvFeatures);
        this._cfgAlwaysQuoteStrings = CsvGenerator.Feature.ALWAYS_QUOTE_STRINGS.enabledIn(csvFeatures);
        this._cfgAlwaysQuoteEmptyStrings = CsvGenerator.Feature.ALWAYS_QUOTE_EMPTY_STRINGS.enabledIn(csvFeatures);
        this._cfgEscapeQuoteCharWithEscapeChar = CsvGenerator.Feature.ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR.enabledIn(csvFeatures);
        this._cfgEscapeControlCharWithEscapeChar = CsvGenerator.Feature.ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR.enabledIn(csvFeatures);
        this._outputBuffer = ctxt.allocConcatBuffer();
        this._bufferRecyclable = true;
        this._outputEnd = this._outputBuffer.length;
        this._out = out;
        this._cfgColumnSeparator = schema.getColumnSeparator();
        this._cfgQuoteCharacter = schema.getQuoteChar();
        this._cfgEscapeCharacter = schema.getEscapeChar();
        this._cfgLineSeparator = schema.getLineSeparator();
        this._cfgLineSeparatorLength = this._cfgLineSeparator == null ? 0 : this._cfgLineSeparator.length;
        this._cfgNullValue = schema.getNullValueOrEmpty();
        this._cfgAllowsComments = schema.allowsComments();
        this._columnCount = schema.size();
        this._cfgMinSafeChar = this._calcSafeChar();
        this._cfgMaxQuoteCheckChars = 24;
        this._cfgQuoteCharEscapeChar = this._getQuoteCharEscapeChar(this._cfgEscapeQuoteCharWithEscapeChar, this._cfgQuoteCharacter, this._cfgEscapeCharacter);
        this._cfgControlCharEscapeChar = (char)(this._cfgEscapeCharacter > 0 ? (int)this._cfgEscapeCharacter : 92);
    }

    public CsvEncoder(CsvEncoder base, CsvSchema newSchema) {
        this._ioContext = base._ioContext;
        this._csvFeatures = base._csvFeatures;
        this._cfgUseFastDoubleWriter = base._cfgUseFastDoubleWriter;
        this._cfgOptimalQuoting = base._cfgOptimalQuoting;
        this._cfgIncludeMissingTail = base._cfgIncludeMissingTail;
        this._cfgAlwaysQuoteStrings = base._cfgAlwaysQuoteStrings;
        this._cfgAlwaysQuoteEmptyStrings = base._cfgAlwaysQuoteEmptyStrings;
        this._cfgEscapeQuoteCharWithEscapeChar = base._cfgEscapeQuoteCharWithEscapeChar;
        this._cfgEscapeControlCharWithEscapeChar = base._cfgEscapeControlCharWithEscapeChar;
        this._outputBuffer = base._outputBuffer;
        this._bufferRecyclable = base._bufferRecyclable;
        this._outputEnd = base._outputEnd;
        this._out = base._out;
        this._cfgMaxQuoteCheckChars = base._cfgMaxQuoteCheckChars;
        this._outputEscapes = base._outputEscapes;
        this._cfgColumnSeparator = newSchema.getColumnSeparator();
        this._cfgQuoteCharacter = newSchema.getQuoteChar();
        this._cfgEscapeCharacter = newSchema.getEscapeChar();
        this._cfgLineSeparator = newSchema.getLineSeparator();
        this._cfgLineSeparatorLength = this._cfgLineSeparator.length;
        this._cfgNullValue = newSchema.getNullValueOrEmpty();
        this._cfgAllowsComments = newSchema.allowsComments();
        this._cfgMinSafeChar = this._calcSafeChar();
        this._columnCount = newSchema.size();
        this._cfgQuoteCharEscapeChar = this._getQuoteCharEscapeChar(base._cfgEscapeQuoteCharWithEscapeChar, newSchema.getQuoteChar(), newSchema.getEscapeChar());
        this._cfgControlCharEscapeChar = (char)(this._cfgEscapeCharacter > 0 ? (int)this._cfgEscapeCharacter : 92);
    }

    private final char _getQuoteCharEscapeChar(boolean escapeQuoteCharWithEscapeChar, int quoteCharacter, int escapeCharacter) {
        char quoteEscapeChar = this._cfgEscapeQuoteCharWithEscapeChar && this._cfgEscapeCharacter > 0 ? (char)((char)this._cfgEscapeCharacter) : (this._cfgQuoteCharacter > 0 ? (char)((char)this._cfgQuoteCharacter) : (char)'\\');
        return quoteEscapeChar;
    }

    private final int _calcSafeChar() {
        int min = Math.max(this._cfgColumnSeparator, this._cfgQuoteCharacter);
        for (int i = 0; i < this._cfgLineSeparatorLength; ++i) {
            min = Math.max(min, this._cfgLineSeparator[i]);
        }
        return min + 1;
    }

    public CsvEncoder withSchema(CsvSchema schema) {
        return new CsvEncoder(this, schema);
    }

    public CsvEncoder overrideFormatFeatures(int feat) {
        if (feat != this._csvFeatures) {
            this._csvFeatures = feat;
            this._cfgOptimalQuoting = CsvGenerator.Feature.STRICT_CHECK_FOR_QUOTING.enabledIn(feat);
            this._cfgIncludeMissingTail = !CsvGenerator.Feature.OMIT_MISSING_TAIL_COLUMNS.enabledIn(feat);
            this._cfgAlwaysQuoteStrings = CsvGenerator.Feature.ALWAYS_QUOTE_STRINGS.enabledIn(feat);
            this._cfgAlwaysQuoteEmptyStrings = CsvGenerator.Feature.ALWAYS_QUOTE_EMPTY_STRINGS.enabledIn(feat);
            this._cfgEscapeQuoteCharWithEscapeChar = CsvGenerator.Feature.ESCAPE_QUOTE_CHAR_WITH_ESCAPE_CHAR.enabledIn(feat);
            this._cfgEscapeControlCharWithEscapeChar = CsvGenerator.Feature.ESCAPE_CONTROL_CHARS_WITH_ESCAPE_CHAR.enabledIn(feat);
        }
        return this;
    }

    public CsvEncoder setOutputEscapes(int[] esc) {
        this._outputEscapes = esc != null ? esc : sOutputEscapes;
        return this;
    }

    public Object getOutputTarget() {
        return this._out;
    }

    public int getOutputBuffered() {
        return this._outputTail;
    }

    public int nextColumnIndex() {
        return this._nextColumnToWrite;
    }

    public final void write(int columnIndex, String value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this.appendColumnSeparator();
            }
            int len = value.length();
            if (this._cfgAlwaysQuoteStrings || this._mayNeedQuotes(value, len, columnIndex)) {
                if (this._cfgEscapeCharacter > 0) {
                    this._writeQuotedAndEscaped(value, (char)this._cfgEscapeCharacter);
                } else {
                    this._writeQuoted(value);
                }
            } else {
                this.writeRaw(value);
            }
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, char[] ch, int offset, int len) throws IOException {
        this.write(columnIndex, new String(ch, offset, len));
    }

    public final void write(int columnIndex, int value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail + 12 > this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
            }
            this._outputTail = NumberOutput.outputInt(value, this._outputBuffer, this._outputTail);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, long value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            if (this._outputTail + 22 > this._outputEnd) {
                this._flushBuffer();
            }
            if (this._nextColumnToWrite > 0) {
                this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
            }
            this._outputTail = NumberOutput.outputLong(value, this._outputBuffer, this._outputTail);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, float value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, double value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void write(int columnIndex, boolean value) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendValue(value);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.buffered(value));
    }

    public final void writeNonEscaped(int columnIndex, String rawValue) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendRawValue(rawValue);
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedRaw(rawValue));
    }

    public final void writeNull(int columnIndex) throws IOException {
        if (columnIndex == this._nextColumnToWrite) {
            this.appendNull();
            ++this._nextColumnToWrite;
            return;
        }
        this._buffer(columnIndex, BufferedValue.bufferedNull());
    }

    public final void writeColumnName(String name) throws IOException {
        this.appendValue(name);
        ++this._nextColumnToWrite;
    }

    public void endRow() throws IOException {
        if (this._lastBuffered >= 0) {
            int last = this._lastBuffered;
            this._lastBuffered = -1;
            while (this._nextColumnToWrite <= last) {
                BufferedValue value = this._buffered[this._nextColumnToWrite];
                if (value != null) {
                    this._buffered[this._nextColumnToWrite] = null;
                    value.write(this);
                } else if (this._nextColumnToWrite > 0) {
                    this.appendColumnSeparator();
                }
                ++this._nextColumnToWrite;
            }
        } else if (this._nextColumnToWrite <= 0) {
            return;
        }
        if (this._nextColumnToWrite < this._columnCount && this._cfgIncludeMissingTail) {
            do {
                this.appendColumnSeparator();
            } while (++this._nextColumnToWrite < this._columnCount);
        }
        this._nextColumnToWrite = 0;
        if (this._outputTail + this._cfgLineSeparatorLength > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(this._cfgLineSeparator, 0, this._outputBuffer, this._outputTail, this._cfgLineSeparatorLength);
        this._outputTail += this._cfgLineSeparatorLength;
    }

    protected void appendValue(String value) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this.appendColumnSeparator();
        }
        int len = value.length();
        if (this._cfgAlwaysQuoteStrings || this._mayNeedQuotes(value, len, this._nextColumnToWrite)) {
            if (this._cfgEscapeCharacter > 0) {
                this._writeQuotedAndEscaped(value, (char)this._cfgEscapeCharacter);
            } else {
                this._writeQuoted(value);
            }
        } else {
            this.writeRaw(value);
        }
    }

    protected void appendRawValue(String value) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this.appendColumnSeparator();
        }
        this.writeRaw(value);
    }

    protected void appendValue(int value) throws IOException {
        if (this._outputTail + 12 > this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputInt(value, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(long value) throws IOException {
        if (this._outputTail + 22 > this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this._outputTail = NumberOutput.outputLong(value, this._outputBuffer, this._outputTail);
    }

    protected void appendValue(float value) throws IOException {
        String str = NumberOutput.toString(value, this._cfgUseFastDoubleWriter);
        int len = str.length();
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this.writeRaw(str);
    }

    protected void appendValue(double value) throws IOException {
        String str = NumberOutput.toString(value, this._cfgUseFastDoubleWriter);
        int len = str.length();
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        this.writeRaw(str);
    }

    protected void appendValue(boolean value) throws IOException {
        this._append(value ? TRUE_CHARS : FALSE_CHARS);
    }

    protected void appendNull() throws IOException {
        this._append(this._cfgNullValue);
    }

    protected void _append(char[] ch) throws IOException {
        int len = ch.length;
        if (this._outputTail + len >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._nextColumnToWrite > 0) {
            this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
        }
        if (len > 0) {
            System.arraycopy(ch, 0, this._outputBuffer, this._outputTail, len);
        }
        this._outputTail += len;
    }

    protected void appendColumnSeparator() throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._cfgColumnSeparator;
    }

    public void writeRaw(String text) throws IOException {
        int len = text.length();
        int room = this._outputEnd - this._outputTail;
        if (room == 0) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(0, len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text);
        }
    }

    public void writeRaw(String text, int start, int len) throws IOException {
        int room = this._outputEnd - this._outputTail;
        if (room < len) {
            this._flushBuffer();
            room = this._outputEnd - this._outputTail;
        }
        if (room >= len) {
            text.getChars(start, start + len, this._outputBuffer, this._outputTail);
            this._outputTail += len;
        } else {
            this.writeRawLong(text.substring(start, start + len));
        }
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException {
        if (len < 32) {
            int room = this._outputEnd - this._outputTail;
            if (len > room) {
                this._flushBuffer();
            }
            System.arraycopy(text, offset, this._outputBuffer, this._outputTail, len);
            this._outputTail += len;
            return;
        }
        this._flushBuffer();
        this._out.write(text, offset, len);
    }

    public void writeRaw(char c) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = c;
    }

    private void writeRawLong(String text) throws IOException {
        int len;
        int amount;
        int room = this._outputEnd - this._outputTail;
        text.getChars(0, room, this._outputBuffer, this._outputTail);
        this._outputTail += room;
        this._flushBuffer();
        int offset = room;
        for (len = text.length() - room; len > this._outputEnd; len -= amount) {
            amount = this._outputEnd;
            text.getChars(offset, offset + amount, this._outputBuffer, 0);
            this._outputTail = amount;
            this._flushBuffer();
            offset += amount;
        }
        text.getChars(offset, offset + len, this._outputBuffer, 0);
        this._outputTail = len;
    }

    public void _writeQuoted(String text) throws IOException {
        char c;
        int ptr;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char q = (char)this._cfgQuoteCharacter;
        this._outputBuffer[this._outputTail++] = q;
        int len = text.length();
        if (this._outputTail + len + len >= this._outputEnd) {
            this._writeLongQuoted(text, q);
            return;
        }
        char[] buf = this._outputBuffer;
        text.getChars(0, len, buf, ptr);
        int end = ptr + len;
        for (ptr = this._outputTail; ptr < end && (c = buf[ptr]) != q && (c >= escLen || escCodes[c] == 0); ++ptr) {
        }
        if (ptr == end) {
            this._outputBuffer[ptr] = q;
            this._outputTail = ptr + 1;
        } else {
            this._writeQuoted(text, q, ptr - this._outputTail);
        }
    }

    protected void _writeQuoted(String text, char q, int i) throws IOException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char[] buf = this._outputBuffer;
        this._outputTail += i;
        int len = text.length();
        while (i < len) {
            int escCode;
            char c = text.charAt(i);
            if (c < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
            } else {
                if (c == q) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    buf[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                }
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                buf[this._outputTail++] = c;
            }
            ++i;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        buf[this._outputTail++] = q;
    }

    private final void _writeLongQuoted(String text, char q) throws IOException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int escCode;
            char c;
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = text.charAt(i)) < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
                continue;
            }
            if (c == q) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = q;
    }

    public void _writeQuotedAndEscaped(String text, char esc) throws IOException {
        char c;
        int ptr;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        char q = (char)this._cfgQuoteCharacter;
        this._outputBuffer[this._outputTail++] = q;
        int len = text.length();
        if (this._outputTail + len + len >= this._outputEnd) {
            this._writeLongQuotedAndEscaped(text, esc);
            return;
        }
        char[] buf = this._outputBuffer;
        text.getChars(0, len, buf, ptr);
        int end = ptr + len;
        for (ptr = this._outputTail; ptr < end && (c = buf[ptr]) != q && c != esc && (c >= escLen || escCodes[c] == 0); ++ptr) {
        }
        if (ptr == end) {
            this._outputBuffer[ptr] = q;
            this._outputTail = ptr + 1;
        } else {
            this._writeQuotedAndEscaped(text, q, esc, ptr - this._outputTail);
        }
    }

    protected void _writeQuotedAndEscaped(String text, char q, char esc, int i) throws IOException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char[] buf = this._outputBuffer;
        this._outputTail += i;
        int len = text.length();
        while (i < len) {
            int escCode;
            char c = text.charAt(i);
            if (c < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
            } else {
                if (c == q) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                } else if (c == esc) {
                    if (this._outputTail >= this._outputEnd) {
                        this._flushBuffer();
                    }
                    this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
                }
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
                buf[this._outputTail++] = c;
            }
            ++i;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        buf[this._outputTail++] = q;
    }

    private final void _writeLongQuotedAndEscaped(String text, char esc) throws IOException {
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        int len = text.length();
        char q = (char)this._cfgQuoteCharacter;
        for (int i = 0; i < len; ++i) {
            int escCode;
            char c;
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c = text.charAt(i)) < escLen && (escCode = escCodes[c]) != 0) {
                this._appendCharacterEscape(c, escCode);
                continue;
            }
            if (c == q) {
                this._outputBuffer[this._outputTail++] = this._cfgQuoteCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            } else if (c == esc) {
                this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
                if (this._outputTail >= this._outputEnd) {
                    this._flushBuffer();
                }
            }
            this._outputBuffer[this._outputTail++] = c;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = q;
    }

    public void flush(boolean flushStream) throws IOException {
        this._flushBuffer();
        if (flushStream) {
            this._out.flush();
        }
    }

    public void close(boolean autoClose, boolean flushStream) throws IOException {
        this._flushBuffer();
        if (autoClose) {
            this._out.close();
        } else if (flushStream) {
            this._out.flush();
        }
        this._releaseBuffers();
    }

    protected boolean _mayNeedQuotes(String value, int length, int columnIndex) {
        if (this._cfgQuoteCharacter < 0) {
            return false;
        }
        if (this._cfgOptimalQuoting) {
            if (this._cfgAllowsComments && columnIndex == 0 && length > 0 && value.charAt(0) == '#') {
                return true;
            }
            if (this._cfgEscapeCharacter > 0) {
                return this._needsQuotingStrict(value, this._cfgEscapeCharacter);
            }
            return this._needsQuotingStrict(value);
        }
        if (length > this._cfgMaxQuoteCheckChars) {
            return true;
        }
        if (this._cfgEscapeCharacter > 0) {
            return this._needsQuotingLoose(value, this._cfgEscapeCharacter);
        }
        if (this._cfgAlwaysQuoteEmptyStrings && length == 0) {
            return true;
        }
        return this._needsQuotingLoose(value);
    }

    protected final boolean _needsQuotingLoose(String value) {
        char esc1 = this._cfgQuoteCharEscapeChar;
        char esc2 = this._cfgControlCharEscapeChar;
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= this._cfgMinSafeChar && c != esc1 && c != esc2) continue;
            return true;
        }
        return false;
    }

    protected final boolean _needsQuotingLoose(String value, int esc) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= this._cfgMinSafeChar && ch != esc) continue;
            return true;
        }
        return false;
    }

    protected boolean _needsQuotingStrict(String value) {
        int minSafe = this._cfgMinSafeChar;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char lfFirst = this._cfgLineSeparatorLength == 0 ? (char)'\u0000' : this._cfgLineSeparator[0];
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c >= minSafe || c != this._cfgColumnSeparator && c != this._cfgQuoteCharacter && (c >= escLen || escCodes[c] == 0) && c != lfFirst) continue;
            return true;
        }
        return false;
    }

    protected boolean _needsQuotingStrict(String value, int esc) {
        int minSafe = this._cfgMinSafeChar;
        int[] escCodes = this._outputEscapes;
        int escLen = escCodes.length;
        char lfFirst = this._cfgLineSeparatorLength == 0 ? (char)'\u0000' : this._cfgLineSeparator[0];
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (!(c < minSafe ? c == this._cfgColumnSeparator || c == this._cfgQuoteCharacter || c < escLen && escCodes[c] != 0 || c == lfFirst : c == esc)) continue;
            return true;
        }
        return false;
    }

    protected void _buffer(int index, BufferedValue v) {
        this._lastBuffered = Math.max(this._lastBuffered, index);
        if (index >= this._buffered.length) {
            this._buffered = Arrays.copyOf(this._buffered, Math.max(index + 1, this._columnCount));
        }
        this._buffered[index] = v;
    }

    protected void _flushBuffer() throws IOException {
        if (this._outputTail > 0) {
            this._charsWritten += this._outputTail;
            this._out.write(this._outputBuffer, 0, this._outputTail);
            this._outputTail = 0;
        }
    }

    public void _releaseBuffers() {
        char[] buf = this._outputBuffer;
        if (buf != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseConcatBuffer(buf);
        }
    }

    private void _appendCharacterEscape(char ch, int escCode) throws IOException {
        if (escCode >= 0) {
            if (this._outputTail + 2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._cfgControlCharEscapeChar;
            this._outputBuffer[this._outputTail++] = (char)escCode;
            return;
        }
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        int ptr = this._outputTail;
        char[] buf = this._outputBuffer;
        buf[ptr++] = 92;
        buf[ptr++] = 117;
        if (ch > '\u00ff') {
            int hi = ch >> 8 & 0xFF;
            buf[ptr++] = HEX_CHARS[hi >> 4];
            buf[ptr++] = HEX_CHARS[hi & 0xF];
            ch = (char)(ch & 0xFF);
        } else {
            buf[ptr++] = 48;
            buf[ptr++] = 48;
        }
        buf[ptr++] = HEX_CHARS[ch >> 4];
        buf[ptr++] = HEX_CHARS[ch & 0xF];
        this._outputTail = ptr;
    }
}

