/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core;

import io.javalin.Javalin;
import io.javalin.core.compression.Brotli;
import io.javalin.core.compression.CompressionStrategy;
import io.javalin.core.compression.Gzip;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.plugin.PluginAlreadyRegisteredException;
import io.javalin.core.plugin.PluginInitLifecycleViolationException;
import io.javalin.core.plugin.PluginLifecycleInit;
import io.javalin.core.plugin.PluginNotFoundException;
import io.javalin.core.security.AccessManager;
import io.javalin.core.security.SecurityUtil;
import io.javalin.core.util.CorsPlugin;
import io.javalin.core.util.Headers;
import io.javalin.core.util.HeadersPlugin;
import io.javalin.core.util.HttpAllowedMethodsOnRoutesUtil;
import io.javalin.core.util.LogUtil;
import io.javalin.http.ContextResolver;
import io.javalin.http.Handler;
import io.javalin.http.RequestLogger;
import io.javalin.http.SinglePageHandler;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.staticfiles.StaticFileConfig;
import io.javalin.jetty.JettyResourceHandler;
import io.javalin.jetty.JettyUtil;
import io.javalin.plugin.json.JavalinJackson;
import io.javalin.plugin.json.JsonMapper;
import io.javalin.websocket.WsConfig;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavalinConfig {
    public boolean autogenerateEtags = false;
    public boolean prefer405over404 = false;
    public boolean enforceSsl = false;
    public boolean showJavalinBanner = true;
    public boolean ignoreTrailingSlashes = true;
    @NotNull
    public String defaultContentType = "text/plain";
    @NotNull
    public String contextPath = "/";
    public Long maxRequestSize = 1000000L;
    @NotNull
    public Long asyncRequestTimeout = 0L;
    @NotNull
    public Inner inner = new Inner();

    public void registerPlugin(@NotNull Plugin plugin) {
        if (this.inner.plugins.containsKey(plugin.getClass())) {
            throw new PluginAlreadyRegisteredException(plugin.getClass());
        }
        this.inner.plugins.put(plugin.getClass(), plugin);
    }

    public <T extends Plugin> T getPlugin(@NotNull Class<T> pluginClass) {
        Plugin result = this.inner.plugins.get(pluginClass);
        if (result == null) {
            throw new PluginNotFoundException(pluginClass);
        }
        return (T)result;
    }

    public void enableDevLogging() {
        this.requestLogger(LogUtil::requestDevLogger);
        this.wsLogger(LogUtil::wsDevLogger);
        this.registerPlugin(new LogUtil.HandlerLoggingPlugin());
    }

    public void enableWebjars() {
        this.addStaticFiles(staticFiles -> {
            staticFiles.directory = "META-INF/resources/webjars";
            staticFiles.headers.put("Cache-Control", "max-age=31622400");
        });
    }

    public void addStaticFiles(@NotNull String directory, @NotNull Location location) {
        this.addStaticFiles(staticFiles -> {
            staticFiles.directory = directory;
            staticFiles.location = location;
        });
    }

    public void addStaticFiles(@NotNull Consumer<StaticFileConfig> userConfig) {
        if (this.inner.resourceHandler == null) {
            this.inner.resourceHandler = new JettyResourceHandler();
        }
        StaticFileConfig finalConfig = new StaticFileConfig();
        userConfig.accept(finalConfig);
        this.inner.resourceHandler.addStaticFileConfig(finalConfig);
    }

    public void addSinglePageRoot(@NotNull String hostedPath, @NotNull String filePath) {
        this.addSinglePageRoot(hostedPath, filePath, Location.CLASSPATH);
    }

    public void addSinglePageRoot(@NotNull String hostedPath, @NotNull String filePath, @NotNull Location location) {
        this.inner.singlePageHandler.add(hostedPath, filePath, location);
    }

    public void addSinglePageHandler(@NotNull String hostedPath, @NotNull Handler customHandler) {
        this.inner.singlePageHandler.add(hostedPath, customHandler);
    }

    public void enableCorsForAllOrigins() {
        this.registerPlugin(CorsPlugin.forAllOrigins());
    }

    public void enableCorsForOrigin(String ... origins) {
        this.registerPlugin(CorsPlugin.forOrigins(origins));
    }

    public void accessManager(@NotNull AccessManager accessManager) {
        this.inner.accessManager = accessManager;
    }

    public void requestLogger(@NotNull RequestLogger requestLogger) {
        this.inner.requestLogger = requestLogger;
    }

    public void sessionHandler(@NotNull Supplier<SessionHandler> sessionHandlerSupplier) {
        JettyUtil.disableJettyLogger();
        this.inner.sessionHandler = sessionHandlerSupplier.get();
    }

    public void wsFactoryConfig(@NotNull Consumer<WebSocketServletFactory> wsFactoryConfig) {
        this.inner.wsFactoryConfig = wsFactoryConfig;
    }

    public void wsLogger(@NotNull Consumer<WsConfig> ws) {
        WsConfig logger = new WsConfig();
        ws.accept(logger);
        this.inner.wsLogger = logger;
    }

    public void server(Supplier<Server> server) {
        this.inner.server = server.get();
    }

    public void configureServletContextHandler(Consumer<ServletContextHandler> consumer) {
        this.inner.servletContextHandlerConsumer = consumer;
    }

    public void compressionStrategy(Brotli brotli, Gzip gzip) {
        this.inner.compressionStrategy = new CompressionStrategy(brotli, gzip);
    }

    public void compressionStrategy(CompressionStrategy compressionStrategy) {
        this.inner.compressionStrategy = compressionStrategy;
    }

    public void globalHeaders(Supplier<Headers> headers) {
        this.registerPlugin(new HeadersPlugin(headers.get()));
    }

    public void jsonMapper(JsonMapper jsonMapper) {
        this.inner.appAttributes.put("global-json-mapper", jsonMapper);
    }

    public static void applyUserConfig(Javalin app, JavalinConfig config, Consumer<JavalinConfig> userConfig) {
        userConfig.accept(config);
        AtomicBoolean anyHandlerAdded = new AtomicBoolean(false);
        app.events(listener -> {
            listener.handlerAdded(x -> anyHandlerAdded.set(true));
            listener.wsHandlerAdded(x -> anyHandlerAdded.set(true));
        });
        config.getPluginsExtending(PluginLifecycleInit.class).forEach(plugin -> {
            plugin.init(app);
            if (anyHandlerAdded.get()) {
                throw new PluginInitLifecycleViolationException(((Plugin)((Object)plugin)).getClass());
            }
        });
        config.inner.plugins.values().forEach(plugin -> plugin.apply(app));
        if (config.enforceSsl) {
            app.before(SecurityUtil::sslRedirect);
        }
        config.inner.appAttributes.putIfAbsent("global-json-mapper", new JavalinJackson());
        app.attribute("javalin-max-request-size", config.maxRequestSize);
        config.inner.appAttributes.putIfAbsent("contextResolver", new ContextResolver());
    }

    private <T> Stream<? extends T> getPluginsExtending(Class<T> clazz) {
        return this.inner.plugins.values().stream().filter(clazz::isInstance).map(plugin -> plugin);
    }

    public void contextResolvers(@NotNull Consumer<ContextResolver> userResolver) {
        ContextResolver finalResolver = new ContextResolver();
        userResolver.accept(finalResolver);
        this.inner.appAttributes.put("contextResolver", finalResolver);
    }

    public void enableHttpAllowedMethodsOnRoutes() {
        this.registerPlugin(new HttpAllowedMethodsOnRoutesUtil());
    }

    public static class Inner {
        @NotNull
        public Map<Class<? extends Plugin>, Plugin> plugins = new LinkedHashMap<Class<? extends Plugin>, Plugin>();
        @NotNull
        public Map<String, Object> appAttributes = new HashMap<String, Object>();
        @Nullable
        public RequestLogger requestLogger = null;
        @Nullable
        public ResourceHandler resourceHandler = null;
        @NotNull
        public AccessManager accessManager = SecurityUtil::noopAccessManager;
        @NotNull
        public SinglePageHandler singlePageHandler = new SinglePageHandler();
        @Nullable
        public SessionHandler sessionHandler = null;
        @Nullable
        public Consumer<WebSocketServletFactory> wsFactoryConfig = null;
        @Nullable
        public WsConfig wsLogger = null;
        @Nullable
        public Server server = null;
        @Nullable
        public Consumer<ServletContextHandler> servletContextHandlerConsumer = null;
        @NotNull
        public CompressionStrategy compressionStrategy = CompressionStrategy.GZIP;
    }
}

