/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.config.shade.utils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.BiFunction;
import org.apache.amoro.config.ConfigOption;
import org.apache.amoro.config.ConfigOptions;
import org.apache.amoro.config.Configurations;
import org.apache.amoro.config.shade.ConfigShade;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigShadeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigShadeUtils.class);
    private static final Map<String, ConfigShade> CONFIG_SHADES = new HashMap<String, ConfigShade>();
    private static final ConfigShade DEFAULT_SHADE = new DefaultConfigShade();
    public static final ConfigOption<String> SHADE_IDENTIFIER_OPTION = ConfigOptions.key("shade.identifier").stringType().defaultValue("default").withDescription("The identifier of the encryption method for decryption. Defaults to \"default\", indicating no encryption");
    public static final ConfigOption<List<String>> SHADE_SENSITIVE_KEYWORDS = ConfigOptions.key("shade.sensitive-keywords").stringType().asList().defaultValues((String[])new String[]{"admin-password", "database.password"}).withDescription("A semicolon-separated list of keywords for the configuration items to be decrypted.");

    @VisibleForTesting
    public static String decryptOption(String identifier, String content) {
        ConfigShade configShade = CONFIG_SHADES.getOrDefault(identifier, DEFAULT_SHADE);
        return configShade.decrypt(content);
    }

    public static Map<String, Object> decryptConfig(Map<String, Object> configMap) throws Exception {
        Configurations serviceConfig = Configurations.fromObjectMap(configMap);
        String identifier = serviceConfig.get(SHADE_IDENTIFIER_OPTION);
        List<String> sensitiveOptions = serviceConfig.get(SHADE_SENSITIVE_KEYWORDS);
        return ConfigShadeUtils.decryptConfig(identifier, configMap, sensitiveOptions, serviceConfig);
    }

    public static Map<String, Object> decryptConfig(String identifier, Map<String, Object> configMap, List<String> sensitiveOptions, Configurations serviceConfig) throws Exception {
        ConfigShade configShade = CONFIG_SHADES.get(identifier);
        if (configShade == null) {
            LOG.error("Can not find config shade: {}", (Object)identifier);
            throw new IllegalStateException("Can not find config shade: " + identifier);
        }
        configShade.initialize(serviceConfig);
        if (DEFAULT_SHADE.getIdentifier().equals(configShade.getIdentifier())) {
            return configMap;
        }
        LOG.info("Use config shade: {}", (Object)identifier);
        BiFunction<String, Object, String> processFunction = (key, value) -> configShade.decrypt(value.toString());
        for (String sensitiveOption : sensitiveOptions) {
            try {
                configMap.computeIfPresent(sensitiveOption, processFunction);
            }
            catch (Exception e) {
                LOG.error("Failed to decrypt sensitive option {}:", (Object)sensitiveOption, (Object)e);
                throw e;
            }
        }
        LOG.info("Sensitive option{} {} {} been decrypted and refreshed", new Object[]{sensitiveOptions.size() > 1 ? "s" : "", sensitiveOptions, sensitiveOptions.size() > 1 ? "have" : "has"});
        return configMap;
    }

    static {
        ServiceLoader<ConfigShade> serviceLoader = ServiceLoader.load(ConfigShade.class);
        Iterator<ConfigShade> it = serviceLoader.iterator();
        it.forEachRemaining(configShade -> {
            CONFIG_SHADES.put(configShade.getIdentifier(), (ConfigShade)configShade);
            LOG.info("Load config shade spi [{}] from {}", (Object)configShade.getIdentifier(), configShade.getClass());
        });
    }

    public static class DefaultConfigShade
    implements ConfigShade {
        private static final String IDENTIFIER = "default";

        @Override
        public String getIdentifier() {
            return IDENTIFIER;
        }

        @Override
        public String decrypt(String content) {
            return content;
        }
    }
}

