/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.FormatCatalog;
import org.apache.amoro.FormatCatalogFactory;
import org.apache.amoro.NoSuchTableException;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.UnifiedCatalog;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.shade.guava32.com.google.common.collect.Maps;
import org.apache.amoro.table.TableIdentifier;
import org.apache.amoro.table.TableMetaStore;
import org.apache.amoro.utils.CatalogUtil;

public class CommonUnifiedCatalog
implements UnifiedCatalog {
    private final String catalogName;
    private final String metaStoreType;
    private final Supplier<CatalogMeta> metaSupplier;
    private final Map<String, String> clientProperties;
    private Map<String, String> catalogProperties;
    private CatalogMeta meta;
    private TableMetaStore tableMetaStore;
    private Map<TableFormat, FormatCatalog> formatCatalogs = Maps.newHashMap();

    public CommonUnifiedCatalog(Supplier<CatalogMeta> catalogMetaSupplier, Map<String, String> properties) {
        CatalogMeta catalogMeta = catalogMetaSupplier.get();
        CatalogUtil.mergeCatalogProperties(catalogMeta, properties);
        this.meta = catalogMeta;
        this.catalogName = catalogMeta.getCatalogName();
        this.metaStoreType = catalogMeta.getCatalogType();
        this.tableMetaStore = CatalogUtil.buildMetaStore(catalogMeta);
        this.clientProperties = properties;
        this.catalogProperties = catalogMeta.getCatalogProperties();
        this.metaSupplier = catalogMetaSupplier;
        this.initializeFormatCatalogs();
    }

    public CommonUnifiedCatalog(String catalogName, String metaStoreType, Map<String, String> properties, TableMetaStore tableMetaStore) {
        this.catalogName = catalogName;
        this.metaStoreType = metaStoreType;
        this.tableMetaStore = tableMetaStore;
        this.clientProperties = properties;
        this.catalogProperties = properties;
        this.metaSupplier = null;
        this.initializeFormatCatalogs();
    }

    @Override
    public String metastoreType() {
        return this.metaStoreType;
    }

    @Override
    public TableMetaStore authenticationContext() {
        return this.tableMetaStore;
    }

    @Override
    public List<String> listDatabases() {
        return this.findFirstFormatCatalog(TableFormat.values()).listDatabases();
    }

    @Override
    public boolean databaseExists(String database) {
        return this.listDatabases().contains(database);
    }

    @Override
    public boolean tableExists(String database, String table) {
        return this.formatCatalogAsOrder(TableFormat.values()).anyMatch(formatCatalog -> formatCatalog.tableExists(database, table));
    }

    @Override
    public void createDatabase(String database) {
        this.findFirstFormatCatalog(TableFormat.values()).createDatabase(database);
    }

    @Override
    public void dropDatabase(String database) {
        if (!this.listTables(database).isEmpty()) {
            throw new IllegalStateException("Database: " + database + " is not empty.");
        }
        this.findFirstFormatCatalog(TableFormat.values()).dropDatabase(database);
    }

    @Override
    public AmoroTable<?> loadTable(String database, String table) {
        return this.formatCatalogAsOrder(TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG, TableFormat.ICEBERG, TableFormat.PAIMON, TableFormat.HUDI).map(formatCatalog -> {
            try {
                return formatCatalog.loadTable(database, table);
            }
            catch (NoSuchTableException e) {
                return null;
            }
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new NoSuchTableException("Table: " + table + " does not exist."));
    }

    @Override
    public String name() {
        return this.catalogName;
    }

    @Override
    public List<TableIDWithFormat> listTables(String database) {
        TableFormat[] formats = new TableFormat[]{TableFormat.MIXED_HIVE, TableFormat.MIXED_ICEBERG, TableFormat.ICEBERG, TableFormat.PAIMON, TableFormat.HUDI};
        HashMap tableNameToFormat = Maps.newHashMap();
        for (TableFormat format : formats) {
            if (!this.formatCatalogs.containsKey(format)) continue;
            this.formatCatalogs.get(format).listTables(database).forEach(table -> tableNameToFormat.putIfAbsent(table, format));
        }
        return tableNameToFormat.keySet().stream().map(tableName -> {
            TableFormat format = (TableFormat)tableNameToFormat.get(tableName);
            return TableIDWithFormat.of(TableIdentifier.of(this.catalogName, database, tableName), format);
        }).collect(Collectors.toList());
    }

    @Override
    public boolean dropTable(String database, String table, boolean purge) {
        try {
            AmoroTable<?> t = this.loadTable(database, table);
            return this.findFirstFormatCatalog(t.format()).dropTable(database, table, purge);
        }
        catch (NoSuchTableException e) {
            return false;
        }
    }

    @Override
    public synchronized void refresh() {
        if (this.metaSupplier != null) {
            CatalogMeta newMeta = this.metaSupplier.get();
            CatalogUtil.mergeCatalogProperties(this.meta, this.clientProperties);
            if (newMeta.equals(this.meta)) {
                return;
            }
            this.catalogProperties = newMeta.getCatalogProperties();
            this.tableMetaStore = CatalogUtil.buildMetaStore(newMeta);
            this.meta = newMeta;
            this.initializeFormatCatalogs();
        }
    }

    @Override
    public Map<String, String> properties() {
        return this.catalogProperties;
    }

    protected void initializeFormatCatalogs() {
        ServiceLoader<FormatCatalogFactory> loader = ServiceLoader.load(FormatCatalogFactory.class);
        Set<TableFormat> formats = CatalogUtil.tableFormats(this.metaStoreType, this.catalogProperties);
        ConcurrentMap formatCatalogs = Maps.newConcurrentMap();
        for (FormatCatalogFactory factory : loader) {
            if (!formats.contains(factory.format())) continue;
            Map<String, String> formatCatalogProperties = factory.convertCatalogProperties(this.name(), this.metaStoreType, this.catalogProperties);
            FormatCatalog catalog = factory.create(this.name(), this.metaStoreType, formatCatalogProperties, this.tableMetaStore);
            formatCatalogs.put(factory.format(), catalog);
        }
        this.formatCatalogs = formatCatalogs;
    }

    private Stream<FormatCatalog> formatCatalogAsOrder(TableFormat ... formats) {
        return Stream.of(formats).filter(this.formatCatalogs::containsKey).map(this.formatCatalogs::get);
    }

    private FormatCatalog findFirstFormatCatalog(TableFormat ... formats) {
        return Stream.of(formats).filter(this.formatCatalogs::containsKey).map(this.formatCatalogs::get).findFirst().orElseThrow(() -> new IllegalStateException("No format catalog found."));
    }
}

