/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.auth;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.kyuubi.jdbc.hive.auth.KerberosUtils;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableMap;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosAuthentication.class);
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private KerberosPrincipal principal = null;
    private final Configuration configuration;

    KerberosAuthentication() {
        this.configuration = KerberosAuthentication.createLoginFromTgtCacheConfiguration();
    }

    KerberosAuthentication(String principal, String keytabLocation) {
        Objects.requireNonNull(principal, "principal is null");
        Objects.requireNonNull(keytabLocation, "keytabLocation is null");
        Path keytabPath = Paths.get(keytabLocation, new String[0]);
        Preconditions.checkArgument(Files.exists(keytabPath, new LinkOption[0]), "keytab does not exist: %s", (Object)keytabLocation);
        Preconditions.checkArgument(Files.isReadable(keytabPath), "keytab is not readable: %s", (Object)keytabLocation);
        this.principal = KerberosAuthentication.createKerberosPrincipal(principal);
        this.configuration = KerberosAuthentication.createLoginFromKeytabConfiguration(this.principal.getName(), keytabLocation);
    }

    public Subject getSubject() {
        Subject subject = this.principal == null ? null : new Subject(false, ImmutableSet.of(this.principal), Collections.emptySet(), Collections.emptySet());
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
            return loginContext.getSubject();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    public void attemptLogin(Subject subject) {
        try {
            LoginContext loginContext = new LoginContext("", subject, null, this.configuration);
            loginContext.login();
        }
        catch (LoginException e) {
            throw new RuntimeException(e);
        }
    }

    private static KerberosPrincipal createKerberosPrincipal(String principal) {
        try {
            return new KerberosPrincipal(KerberosUtils.canonicalClientPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Configuration createLoginFromTgtCacheConfiguration() {
        ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder().put("useTicketCache", "true").put("renewTGT", "true");
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            optionsBuilder.put("ticketCache", ticketCache);
        }
        return KerberosAuthentication.createConfiguration(optionsBuilder);
    }

    private static Configuration createLoginFromKeytabConfiguration(String principal, String keytabLocation) {
        ImmutableMap.Builder<String, String> optionsBuilder = ImmutableMap.builder().put("useKeyTab", "true").put("storeKey", "true").put("refreshKrb5Config", "true").put("principal", principal).put("keyTab", keytabLocation);
        return KerberosAuthentication.createConfiguration(optionsBuilder);
    }

    private static Configuration createConfiguration(ImmutableMap.Builder<String, String> optionsBuilder) {
        if (LOG.isDebugEnabled()) {
            optionsBuilder.put("debug", "true");
        }
        final ImmutableMap<String, String> options = optionsBuilder.put("doNotPrompt", "true").build();
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosAuthentication.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
            }
        };
    }
}

