/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.amoro.hive.utils.TimeUtil;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

class AdaptHiveParquetConversions {
    private AdaptHiveParquetConversions() {
    }

    static <T> Literal<T> fromParquetPrimitive(Type type, PrimitiveType parquetType, Object value) {
        switch (type.typeId()) {
            case BOOLEAN: {
                return Literal.of((boolean)((Boolean)value));
            }
            case INTEGER: 
            case DATE: {
                return Literal.of((int)((Integer)value));
            }
            case LONG: 
            case TIME: 
            case TIMESTAMP: {
                Function<Object, Object> timeConversion = AdaptHiveParquetConversions.converterFromParquet(parquetType, type);
                return Literal.of((long)((Long)timeConversion.apply(value)));
            }
            case FLOAT: {
                return Literal.of((float)((Float)value).floatValue());
            }
            case DOUBLE: {
                return Literal.of((double)((Double)value));
            }
            case STRING: {
                Function<Object, Object> stringConversion = AdaptHiveParquetConversions.converterFromParquet(parquetType);
                return Literal.of((CharSequence)((CharSequence)stringConversion.apply(value)));
            }
            case UUID: {
                Function<Object, Object> uuidConversion = AdaptHiveParquetConversions.converterFromParquet(parquetType);
                return Literal.of((UUID)((UUID)uuidConversion.apply(value)));
            }
            case FIXED: 
            case BINARY: {
                Function<Object, Object> binaryConversion = AdaptHiveParquetConversions.converterFromParquet(parquetType);
                return Literal.of((ByteBuffer)((ByteBuffer)binaryConversion.apply(value)));
            }
            case DECIMAL: {
                Function<Object, Object> decimalConversion = AdaptHiveParquetConversions.converterFromParquet(parquetType);
                return Literal.of((BigDecimal)((BigDecimal)decimalConversion.apply(value)));
            }
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + type);
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType parquetType, Type icebergType) {
        if (parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT96) {
            return binary -> {
                ByteBuffer byteBuffer = ByteBuffer.wrap(((Binary)binary).getBytes()).order(ByteOrder.LITTLE_ENDIAN);
                long timeOfDayNanos = byteBuffer.getLong();
                int julianDay = byteBuffer.getInt();
                Instant instant = Instant.ofEpochMilli(TimeUnit.DAYS.toMillis((long)julianDay - 2440588L)).plusNanos(timeOfDayNanos);
                if (!((Types.TimestampType)icebergType).shouldAdjustToUTC()) {
                    instant = LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toInstant(ZoneOffset.UTC);
                }
                return TimeUtil.microsBetween(Instant.EPOCH, instant);
            };
        }
        if (icebergType != null && icebergType.typeId() == Type.TypeID.STRING && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.BINARY) {
            return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
        }
        Function<Object, Object> fromParquet = AdaptHiveParquetConversions.converterFromParquet(parquetType);
        if (icebergType != null) {
            if (icebergType.typeId() == Type.TypeID.LONG && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                return value -> ((Integer)fromParquet.apply(value)).longValue();
            }
            if (icebergType.typeId() == Type.TypeID.DOUBLE && parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return value -> ((Float)fromParquet.apply(value)).doubleValue();
            }
        }
        return fromParquet;
    }

    static Function<Object, Object> converterFromParquet(PrimitiveType type) {
        if (type.getOriginalType() != null) {
            switch (type.getOriginalType()) {
                case UTF8: {
                    return binary -> StandardCharsets.UTF_8.decode(((Binary)binary).toByteBuffer());
                }
                case DECIMAL: {
                    int scale = type.getDecimalMetadata().getScale();
                    switch (type.getPrimitiveTypeName()) {
                        case INT32: 
                        case INT64: {
                            return num -> BigDecimal.valueOf(((Number)num).longValue(), scale);
                        }
                        case FIXED_LEN_BYTE_ARRAY: 
                        case BINARY: {
                            return bin -> new BigDecimal(new BigInteger(((Binary)bin).getBytes()), scale);
                        }
                    }
                    throw new IllegalArgumentException("Unsupported primitive type for decimal: " + type.getPrimitiveTypeName());
                }
            }
        }
        switch (type.getPrimitiveTypeName()) {
            case FIXED_LEN_BYTE_ARRAY: 
            case BINARY: {
                return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
            }
        }
        return obj -> obj;
    }
}

