/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.hive.io.writer;

import java.util.Locale;
import java.util.Map;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.hive.io.writer.AdaptHiveOperateToTableRelation;
import org.apache.amoro.hive.io.writer.AdaptHiveOutputFileFactory;
import org.apache.amoro.hive.table.HiveLocationKind;
import org.apache.amoro.hive.table.SupportHive;
import org.apache.amoro.hive.utils.TableTypeUtil;
import org.apache.amoro.io.writer.CommonOutputFileFactory;
import org.apache.amoro.io.writer.GenericBaseTaskWriter;
import org.apache.amoro.io.writer.GenericChangeTaskWriter;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.SortedPosDeleteWriter;
import org.apache.amoro.io.writer.TaskWriterBuilder;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.table.BaseLocationKind;
import org.apache.amoro.table.ChangeLocationKind;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.LocationKind;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.amoro.table.WriteOperationKind;
import org.apache.amoro.utils.SchemaUtil;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.data.AdaptHiveGenericAppenderFactory;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.util.PropertyUtil;

public class AdaptHiveGenericTaskWriterBuilder
implements TaskWriterBuilder<Record> {
    private final MixedTable table;
    private Long transactionId;
    private int partitionId = 0;
    private int taskId = 0;
    private ChangeAction changeAction = ChangeAction.INSERT;
    private String customHiveSubdirectory;
    private Long targetFileSize;
    private boolean orderedWriter = false;
    private Boolean hiveConsistentWrite;

    private AdaptHiveGenericTaskWriterBuilder(MixedTable table) {
        this.table = table;
        this.hiveConsistentWrite = PropertyUtil.propertyAsBoolean((Map)table.properties(), (String)"base.hive.consistent-write.enabled", (boolean)true);
    }

    public AdaptHiveGenericTaskWriterBuilder withTransactionId(Long transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withTaskId(int taskId) {
        this.taskId = taskId;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withChangeAction(ChangeAction changeAction) {
        this.changeAction = changeAction;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withCustomHiveSubdirectory(String customHiveSubdirectory) {
        this.customHiveSubdirectory = customHiveSubdirectory;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withTargetFileSize(long targetFileSize) {
        this.targetFileSize = targetFileSize;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder withOrdered() {
        this.orderedWriter = true;
        return this;
    }

    public AdaptHiveGenericTaskWriterBuilder hiveConsistentWrite(boolean enabled) {
        this.hiveConsistentWrite = enabled;
        return this;
    }

    public TaskWriter<Record> buildWriter(WriteOperationKind writeOperationKind) {
        LocationKind locationKind = AdaptHiveOperateToTableRelation.INSTANT.getLocationKindsFromOperateKind(this.table, writeOperationKind);
        return this.buildWriter(locationKind);
    }

    public TaskWriter<Record> buildWriter(LocationKind locationKind) {
        if (locationKind == ChangeLocationKind.INSTANT) {
            return this.buildChangeWriter();
        }
        if (locationKind == BaseLocationKind.INSTANT || locationKind == HiveLocationKind.INSTANT) {
            return this.buildBaseWriter(locationKind);
        }
        throw new IllegalArgumentException("Not support Location Kind:" + locationKind);
    }

    public SortedPosDeleteWriter<Record> buildBasePosDeleteWriter(long mask, long index, StructLike partitionKey) {
        this.writeBasePreconditions();
        UnkeyedTable baseTable = this.table.isKeyedTable() ? this.table.asKeyedTable().baseTable() : this.table.asUnkeyedTable();
        FileFormat fileFormat = FileFormat.valueOf((String)baseTable.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(baseTable.schema(), baseTable.spec());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_PATH.name(), MetricsModes.Full.get().toString());
        appenderFactory.set("write.metadata.metrics.column." + MetadataColumns.DELETE_FILE_POS.name(), MetricsModes.Full.get().toString());
        return new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, (OutputFileFactory)new CommonOutputFileFactory(baseTable.location(), baseTable.spec(), fileFormat, baseTable.io(), baseTable.encryption(), this.partitionId, (long)this.taskId, this.transactionId), this.table.io(), fileFormat, mask, index, partitionKey);
    }

    private GenericBaseTaskWriter buildBaseWriter(LocationKind locationKind) {
        Schema schema;
        EncryptionManager encryptionManager;
        String baseLocation;
        this.writeBasePreconditions();
        FileFormat fileFormat = FileFormat.valueOf((String)this.table.properties().getOrDefault("base.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        long fileSizeBytes = this.targetFileSize == null ? PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L) : this.targetFileSize;
        long mask = PropertyUtil.propertyAsLong((Map)this.table.properties(), (String)"base.file-index.hash-bucket", (long)4L) - 1L;
        PrimaryKeySpec primaryKeySpec = null;
        if (this.table.isKeyedTable()) {
            KeyedTable keyedTable = this.table.asKeyedTable();
            baseLocation = keyedTable.baseLocation();
            encryptionManager = keyedTable.baseTable().encryption();
            schema = keyedTable.baseTable().schema();
            primaryKeySpec = keyedTable.primaryKeySpec();
        } else {
            UnkeyedTable table = this.table.asUnkeyedTable();
            baseLocation = table.location();
            encryptionManager = table.encryption();
            schema = table.schema();
        }
        AdaptHiveOutputFileFactory outputFileFactory = locationKind == HiveLocationKind.INSTANT ? new AdaptHiveOutputFileFactory(((SupportHive)this.table).hiveLocation(), this.table.spec(), fileFormat, this.table.io(), encryptionManager, this.partitionId, this.taskId, this.transactionId, this.customHiveSubdirectory, this.hiveConsistentWrite) : new CommonOutputFileFactory(baseLocation, this.table.spec(), fileFormat, this.table.io(), encryptionManager, this.partitionId, (long)this.taskId, this.transactionId);
        AdaptHiveGenericAppenderFactory appenderFactory = TableTypeUtil.isHive(this.table) ? new AdaptHiveGenericAppenderFactory(schema, this.table.spec()) : new GenericAppenderFactory(schema, this.table.spec());
        return new GenericBaseTaskWriter(fileFormat, (FileAppenderFactory)appenderFactory, (OutputFileFactory)outputFileFactory, this.table.io(), fileSizeBytes, mask, schema, this.table.spec(), primaryKeySpec, this.orderedWriter);
    }

    private GenericChangeTaskWriter buildChangeWriter() {
        if (this.table.isUnkeyedTable()) {
            throw new IllegalArgumentException("UnKeyed table UnSupport change writer");
        }
        KeyedTable table = (KeyedTable)this.table;
        FileFormat fileFormat = FileFormat.valueOf((String)table.properties().getOrDefault("change.write.format", "parquet").toUpperCase(Locale.ENGLISH));
        long fileSizeBytes = this.targetFileSize == null ? PropertyUtil.propertyAsLong((Map)table.properties(), (String)"write.target-file-size-bytes", (long)0x8000000L) : this.targetFileSize;
        long mask = PropertyUtil.propertyAsLong((Map)table.properties(), (String)"change.file-index.hash-bucket", (long)4L) - 1L;
        Schema changeWriteSchema = SchemaUtil.changeWriteSchema((Schema)table.changeTable().schema());
        AdaptHiveGenericAppenderFactory appenderFactory = TableTypeUtil.isHive((MixedTable)table) ? new AdaptHiveGenericAppenderFactory(changeWriteSchema, table.spec()) : new GenericAppenderFactory(changeWriteSchema, table.spec());
        return new GenericChangeTaskWriter(fileFormat, (FileAppenderFactory)appenderFactory, (OutputFileFactory)new CommonOutputFileFactory(table.changeLocation(), table.spec(), fileFormat, table.io(), table.changeTable().encryption(), this.partitionId, (long)this.taskId, this.transactionId), table.io(), fileSizeBytes, mask, table.changeTable().schema(), table.spec(), table.primaryKeySpec(), this.changeAction, this.orderedWriter);
    }

    private void writeBasePreconditions() {
        if (this.table.isKeyedTable()) {
            Preconditions.checkNotNull((Object)this.transactionId);
        } else {
            Preconditions.checkArgument((this.transactionId == null ? 1 : 0) != 0);
        }
    }

    public static AdaptHiveGenericTaskWriterBuilder builderFor(MixedTable table) {
        return new AdaptHiveGenericTaskWriterBuilder(table);
    }
}

