/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized.parquet;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;

public class BaseVectorizedParquetValuesReader
extends ValuesReader {
    private ByteBufferInputStream inputStream;
    private int bitWidth;
    private int bytesWidth;
    private BytePacker packer;
    Mode mode;
    int currentCount;
    int currentValue;
    int[] packedValuesBuffer = new int[16];
    int packedValuesBufferIdx = 0;
    private final boolean fixedWidth;
    private final boolean readLength;
    final int maxDefLevel;
    final boolean setArrowValidityVector;

    public BaseVectorizedParquetValuesReader(int maxDefLevel, boolean setValidityVector) {
        this.maxDefLevel = maxDefLevel;
        this.fixedWidth = false;
        this.readLength = false;
        this.setArrowValidityVector = setValidityVector;
    }

    public BaseVectorizedParquetValuesReader(int bitWidth, int maxDefLevel, boolean setValidityVector) {
        this(bitWidth, maxDefLevel, bitWidth != 0, setValidityVector);
    }

    public BaseVectorizedParquetValuesReader(int bitWidth, int maxDefLevel, boolean readLength, boolean setValidityVector) {
        this.fixedWidth = true;
        this.readLength = readLength;
        this.maxDefLevel = maxDefLevel;
        this.setArrowValidityVector = setValidityVector;
        this.init(bitWidth);
    }

    public void initFromPage(int valueCount, ByteBufferInputStream in) throws IOException {
        this.inputStream = in;
        if (this.fixedWidth) {
            if (this.readLength) {
                int length = this.readIntLittleEndian();
                this.inputStream = in.sliceStream((long)length);
            }
        } else if (in.available() > 0) {
            this.init(in.read());
        }
        if (this.bitWidth == 0) {
            this.mode = Mode.RLE;
            this.currentCount = valueCount;
            this.currentValue = 0;
        } else {
            this.currentCount = 0;
        }
    }

    private void init(int bw) {
        Preconditions.checkArgument((bw >= 0 && bw <= 32 ? 1 : 0) != 0, (Object)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bw;
        this.bytesWidth = BytesUtils.paddedByteCountFromBits((int)bw);
        this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bw);
    }

    private int readUnsignedVarInt() throws IOException {
        int byteRead;
        int value = 0;
        int shift = 0;
        do {
            byteRead = this.inputStream.read();
            value |= (byteRead & 0x7F) << shift;
            shift += 7;
        } while ((byteRead & 0x80) != 0);
        return value;
    }

    private int readIntLittleEndian() throws IOException {
        int ch4 = this.inputStream.read();
        int ch3 = this.inputStream.read();
        int ch2 = this.inputStream.read();
        int ch1 = this.inputStream.read();
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
    }

    private int readIntLittleEndianPaddedOnBitWidth() throws IOException {
        switch (this.bytesWidth) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.inputStream.read();
            }
            case 2: {
                int ch2 = this.inputStream.read();
                int ch1 = this.inputStream.read();
                return (ch1 << 8) + ch2;
            }
            case 3: {
                int ch3 = this.inputStream.read();
                int ch2 = this.inputStream.read();
                int ch1 = this.inputStream.read();
                return (ch1 << 16) + (ch2 << 8) + ch3;
            }
            case 4: {
                return this.readIntLittleEndian();
            }
        }
        throw new RuntimeException("Non-supported bytesWidth: " + this.bytesWidth);
    }

    void readNextGroup() {
        try {
            int header = this.readUnsignedVarInt();
            this.mode = (header & 1) == 0 ? Mode.RLE : Mode.PACKED;
            switch (this.mode) {
                case RLE: {
                    this.currentCount = header >>> 1;
                    this.currentValue = this.readIntLittleEndianPaddedOnBitWidth();
                    return;
                }
                case PACKED: {
                    int numGroups = header >>> 1;
                    this.currentCount = numGroups * 8;
                    if (this.packedValuesBuffer.length < this.currentCount) {
                        this.packedValuesBuffer = new int[this.currentCount];
                    }
                    this.packedValuesBufferIdx = 0;
                    for (int valueIndex = 0; valueIndex < this.currentCount; valueIndex += 8) {
                        ByteBuffer buffer = this.inputStream.slice(this.bitWidth);
                        this.packer.unpack8Values(buffer, buffer.position(), this.packedValuesBuffer, valueIndex);
                    }
                    return;
                }
            }
            throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Failed to read from input stream", (Throwable)e);
        }
    }

    public boolean readBoolean() {
        return this.readInteger() != 0;
    }

    public void skip() {
        throw new UnsupportedOperationException();
    }

    public int readValueDictionaryId() {
        return this.readInteger();
    }

    public int readInteger() {
        if (this.currentCount == 0) {
            this.readNextGroup();
        }
        --this.currentCount;
        switch (this.mode) {
            case RLE: {
                return this.currentValue;
            }
            case PACKED: {
                return this.packedValuesBuffer[this.packedValuesBufferIdx++];
            }
        }
        throw new RuntimeException("Unrecognized mode: " + (Object)((Object)this.mode));
    }

    static enum Mode {
        RLE,
        PACKED;

    }
}

