/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow.vectorized;

import java.util.Arrays;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.iceberg.arrow.vectorized.ColumnVector;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class ColumnarBatch
implements AutoCloseable {
    private final int numRows;
    private final ColumnVector[] columns;

    ColumnarBatch(int numRows, ColumnVector[] columns) {
        for (int i = 0; i < columns.length; ++i) {
            int columnValueCount = columns[i].getFieldVector().getValueCount();
            Preconditions.checkArgument((numRows == columnValueCount ? 1 : 0) != 0, (Object)("Number of rows (=" + numRows + ") != column[" + i + "] size (=" + columnValueCount + ")"));
        }
        this.numRows = numRows;
        this.columns = columns;
    }

    public VectorSchemaRoot createVectorSchemaRootFromVectors() {
        return VectorSchemaRoot.of((FieldVector[])((FieldVector[])Arrays.stream(this.columns).map(ColumnVector::getArrowVector).toArray(FieldVector[]::new)));
    }

    @Override
    public void close() {
        for (ColumnVector c : this.columns) {
            c.close();
        }
    }

    public int numCols() {
        return this.columns.length;
    }

    public int numRows() {
        return this.numRows;
    }

    public ColumnVector column(int ordinal) {
        return this.columns[ordinal];
    }
}

