/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.arrow;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;

public class ArrowSchemaUtil {
    private static final String ORIGINAL_TYPE = "originalType";
    private static final String MAP_TYPE = "mapType";

    private ArrowSchemaUtil() {
    }

    public static org.apache.arrow.vector.types.pojo.Schema convert(Schema schema) {
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Types.NestedField f : schema.columns()) {
            fields.add((Object)ArrowSchemaUtil.convert(f));
        }
        return new org.apache.arrow.vector.types.pojo.Schema((Iterable)fields.build());
    }

    public static Field convert(Types.NestedField field) {
        ArrowType.Binary arrowType;
        ArrayList children = Lists.newArrayList();
        ImmutableMap metadata = null;
        switch (field.type().typeId()) {
            case BINARY: {
                arrowType = ArrowType.Binary.INSTANCE;
                break;
            }
            case FIXED: {
                Types.FixedType fixedType = (Types.FixedType)field.type();
                arrowType = new ArrowType.FixedSizeBinary(fixedType.length());
                break;
            }
            case BOOLEAN: {
                arrowType = ArrowType.Bool.INSTANCE;
                break;
            }
            case INTEGER: {
                arrowType = new ArrowType.Int(32, true);
                break;
            }
            case LONG: {
                arrowType = new ArrowType.Int(64, true);
                break;
            }
            case FLOAT: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.SINGLE);
                break;
            }
            case DOUBLE: {
                arrowType = new ArrowType.FloatingPoint(FloatingPointPrecision.DOUBLE);
                break;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)field.type();
                arrowType = new ArrowType.Decimal(decimalType.precision(), decimalType.scale());
                break;
            }
            case STRING: {
                arrowType = ArrowType.Utf8.INSTANCE;
                break;
            }
            case TIME: {
                arrowType = new ArrowType.Time(TimeUnit.MICROSECOND, 64);
                break;
            }
            case UUID: {
                arrowType = new ArrowType.FixedSizeBinary(16);
                break;
            }
            case TIMESTAMP: {
                arrowType = new ArrowType.Timestamp(TimeUnit.MICROSECOND, ((Types.TimestampType)field.type()).shouldAdjustToUTC() ? "UTC" : null);
                break;
            }
            case DATE: {
                arrowType = new ArrowType.Date(DateUnit.DAY);
                break;
            }
            case STRUCT: {
                Types.StructType struct = field.type().asStructType();
                arrowType = ArrowType.Struct.INSTANCE;
                for (Types.NestedField nested : struct.fields()) {
                    children.add(ArrowSchemaUtil.convert(nested));
                }
                break;
            }
            case LIST: {
                Types.ListType listType = field.type().asListType();
                arrowType = ArrowType.List.INSTANCE;
                for (Types.NestedField nested : listType.fields()) {
                    children.add(ArrowSchemaUtil.convert(nested));
                }
                break;
            }
            case MAP: {
                metadata = ImmutableMap.of((Object)ORIGINAL_TYPE, (Object)MAP_TYPE);
                Types.MapType mapType = field.type().asMapType();
                arrowType = new ArrowType.Map(false);
                List entryFields = Lists.transform((List)mapType.fields(), ArrowSchemaUtil::convert);
                Field entry = new Field("", new FieldType(field.isOptional(), (ArrowType)arrowType, null), entryFields);
                children.add(entry);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported field type: " + field);
            }
        }
        return new Field(field.name(), new FieldType(field.isOptional(), (ArrowType)arrowType, null, (Map)metadata), (List)children);
    }
}

