/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote;

import java.util.Arrays;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageUtils;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.file.PartitionFileWriter;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteCacheManager;
import org.apache.flink.util.Preconditions;

public class RemoteTierProducerAgent
implements TierProducerAgent {
    private final int numSubpartitions;
    private final int numBuffersPerSegment;
    private final RemoteCacheManager cacheDataManager;
    private final TieredStorageMemoryManager memoryManager;
    private final int[] currentSubpartitionSegmentWriteBuffers;

    RemoteTierProducerAgent(TieredStoragePartitionId partitionId, int numSubpartitions, int numBytesPerSegment, int bufferSizeBytes, boolean isBroadcastOnly, PartitionFileWriter partitionFileWriter, TieredStorageMemoryManager memoryManager, TieredStorageResourceRegistry resourceRegistry) {
        Preconditions.checkArgument((numBytesPerSegment >= bufferSizeBytes ? 1 : 0) != 0, (Object)"One segment should contain at least one buffer.");
        this.numSubpartitions = numSubpartitions;
        this.numBuffersPerSegment = numBytesPerSegment / bufferSizeBytes;
        this.memoryManager = memoryManager;
        this.cacheDataManager = new RemoteCacheManager(partitionId, isBroadcastOnly ? 1 : numSubpartitions, memoryManager, partitionFileWriter);
        this.currentSubpartitionSegmentWriteBuffers = new int[numSubpartitions];
        Arrays.fill(this.currentSubpartitionSegmentWriteBuffers, 0);
        resourceRegistry.registerResource(partitionId, this::releaseAllResources);
    }

    @Override
    public boolean tryStartNewSegment(TieredStorageSubpartitionId subpartitionId, int segmentId, int minNumBuffers) {
        this.cacheDataManager.startSegment(subpartitionId.getSubpartitionId(), segmentId);
        return true;
    }

    @Override
    public boolean tryWrite(TieredStorageSubpartitionId subpartitionId, Buffer buffer, Object bufferOwner, int numRemainingConsecutiveBuffers) {
        int subpartitionIndex = subpartitionId.getSubpartitionId();
        if (this.currentSubpartitionSegmentWriteBuffers[subpartitionIndex] != 0 && this.currentSubpartitionSegmentWriteBuffers[subpartitionIndex] + 1 + numRemainingConsecutiveBuffers > this.numBuffersPerSegment) {
            this.cacheDataManager.finishSegment(subpartitionIndex);
            this.currentSubpartitionSegmentWriteBuffers[subpartitionIndex] = 0;
            return false;
        }
        if (buffer.isBuffer()) {
            this.memoryManager.transferBufferOwnership(bufferOwner, TieredStorageUtils.getRemoteTierName(), buffer);
        }
        int n = subpartitionIndex;
        this.currentSubpartitionSegmentWriteBuffers[n] = this.currentSubpartitionSegmentWriteBuffers[n] + 1;
        this.cacheDataManager.appendBuffer(buffer, subpartitionIndex);
        return true;
    }

    @Override
    public void close() {
        for (int subpartitionId = 0; subpartitionId < this.numSubpartitions; ++subpartitionId) {
            this.cacheDataManager.finishSegment(subpartitionId);
        }
        this.cacheDataManager.close();
    }

    private void releaseAllResources() {
        this.cacheDataManager.release();
    }
}

