/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.asyncprocessing;

import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.runtime.asyncprocessing.RecordContext;
import org.apache.flink.runtime.asyncprocessing.StateRequest;
import org.apache.flink.runtime.asyncprocessing.StateRequestContainer;
import org.apache.flink.runtime.asyncprocessing.StateRequestType;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

@NotThreadSafe
public class StateRequestBuffer<K> {
    private static final ScheduledThreadPoolExecutor DELAYER = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ExecutorThreadFactory("StateRequestBuffer-timeout-scheduler"));
    final LinkedList<StateRequest<K, ?, ?>> activeQueue = new LinkedList();
    final Map<K, Deque<StateRequest<K, ?, ?>>> blockingQueue = new HashMap();
    int blockingQueueSize = 0;
    final long bufferTimeout;
    final Consumer<Long> timeoutHandler;
    ScheduledExecutorService scheduledExecutor;
    ScheduledFuture<Void> currentScheduledFuture;
    AtomicLong scheduledSeq;
    AtomicLong currentSeq;

    public StateRequestBuffer(long bufferTimeout, Consumer<Long> timeoutHandler) {
        this.bufferTimeout = bufferTimeout;
        this.timeoutHandler = timeoutHandler;
        this.scheduledSeq = new AtomicLong(-1L);
        this.currentSeq = new AtomicLong(0L);
        if (bufferTimeout > 0L) {
            this.scheduledExecutor = DELAYER;
        }
    }

    void advanceSeq() {
        this.currentSeq.incrementAndGet();
    }

    boolean checkCurrentSeq(long seq) {
        return this.currentSeq.get() == seq;
    }

    void enqueueToActive(StateRequest<K, ?, ?> request) {
        if (request.getRequestType() == StateRequestType.SYNC_POINT) {
            request.getFuture().complete(null);
        } else {
            this.activeQueue.add(request);
            if (this.bufferTimeout > 0L && this.currentSeq.get() > this.scheduledSeq.get()) {
                if (this.currentScheduledFuture != null && !this.currentScheduledFuture.isDone() && !this.currentScheduledFuture.isCancelled()) {
                    this.currentScheduledFuture.cancel(false);
                }
                long thisScheduledSeq = this.currentSeq.get();
                this.scheduledSeq.set(thisScheduledSeq);
                this.currentScheduledFuture = this.scheduledExecutor.schedule(() -> {
                    if (thisScheduledSeq == this.currentSeq.get()) {
                        this.timeoutHandler.accept(thisScheduledSeq);
                    }
                }, this.bufferTimeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    void enqueueToBlocking(StateRequest<K, ?, ?> request) {
        this.blockingQueue.computeIfAbsent(request.getRecordContext().getKey(), k -> new LinkedList()).add(request);
        ++this.blockingQueueSize;
    }

    @Nullable
    RecordContext<K> tryActivateOneByKey(K key) {
        if (!this.blockingQueue.containsKey(key)) {
            return null;
        }
        StateRequest<K, ?, ?> stateRequest = this.blockingQueue.get(key).removeFirst();
        this.enqueueToActive(stateRequest);
        if (this.blockingQueue.get(key).isEmpty()) {
            this.blockingQueue.remove(key);
        }
        --this.blockingQueueSize;
        return stateRequest.getRecordContext();
    }

    int blockingQueueSize() {
        return this.blockingQueueSize;
    }

    int activeQueueSize() {
        return this.activeQueue.size();
    }

    Optional<StateRequestContainer> popActive(int n, Supplier<StateRequestContainer> requestContainerInitializer) {
        int count = Math.min(n, this.activeQueue.size());
        if (count <= 0) {
            return Optional.empty();
        }
        StateRequestContainer stateRequestContainer = requestContainerInitializer.get();
        for (int i = 0; i < count; ++i) {
            stateRequestContainer.offer(this.activeQueue.pop());
        }
        return Optional.of(stateRequestContainer);
    }

    static {
        DELAYER.setRemoveOnCancelPolicy(true);
        DELAYER.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        DELAYER.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
    }
}

