/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.TimestampFormatterHelper;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(timestamp, fmt) - Converts `timestamp` to a value of string in the format specified by the date format `fmt`.", arguments="\n    Arguments:\n      * timestamp - A date/timestamp or string to be converted to the given format.\n      * fmt - Date/time format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid date\n              and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2016-04-08', 'y');\n       2016\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\u0013'\u0001NB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u00039\u0006\u0002\u00034\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000b\u001d\u0004A\u0011\u00015\t\u000b\u001d\u0004A\u0011A7\t\u000bA\u0004A\u0011I9\t\u000ba\u0004A\u0011I=\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011q\u0003\u0001\u0005R\u0005e\u0001bBA\u0015\u0001\u0011\u0005\u00131\u0006\u0005\b\u0003\u000f\u0002A\u0011IA%\u0011\u0019\tY\u0005\u0001C)\u001f\"9\u0011Q\n\u0001\u0005R\u0005=\u0003bBA,\u0001\u0011E\u0013\u0011\f\u0005\n\u0003G\u0002\u0011\u0011!C\u0001\u0003KB\u0011\"!\u001c\u0001#\u0003%\t!a\u001c\t\u0013\u0005\u0015\u0005!%A\u0005\u0002\u0005=\u0004\"CAD\u0001E\u0005I\u0011AAE\u0011%\ti\tAA\u0001\n\u0003\ny\tC\u0005\u0002 \u0002\t\t\u0011\"\u0001\u0002\"\"I\u0011\u0011\u0016\u0001\u0002\u0002\u0013\u0005\u00111\u0016\u0005\n\u0003c\u0003\u0011\u0011!C!\u0003gC\u0011\"!1\u0001\u0003\u0003%\t!a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAzM\u0005\u0005\t\u0012AA{\r!)c%!A\t\u0002\u0005]\bBB4\u001e\t\u0003\u0011)\u0001C\u0005\u0003\bu\t\t\u0011\"\u0012\u0003\n!I!1B\u000f\u0002\u0002\u0013\u0005%Q\u0002\u0005\n\u0005+i\u0012\u0013!C\u0001\u0003\u0013C\u0011Ba\u0006\u001e\u0003\u0003%\tI!\u0007\t\u0013\t\u001dR$%A\u0005\u0002\u0005%\u0005\"\u0003B\u0015;\u0005\u0005I\u0011\u0002B\u0016\u0005=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c(BA\u0014)\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005%R\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005-b\u0013aA:rY*\u0011QFL\u0001\u0006gB\f'o\u001b\u0006\u0003_A\na!\u00199bG\",'\"A\u0019\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001!\u0004h\u000f F\u0017B\u0011QGN\u0007\u0002M%\u0011qG\n\u0002\u0011\u0005&t\u0017M]=FqB\u0014Xm]:j_:\u0004\"!N\u001d\n\u0005i2#\u0001\u0007+j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJDU\r\u001c9feB\u0011Q\u0007P\u0005\u0003{\u0019\u0012a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003\u007f\ts!!\u000e!\n\u0005\u00053\u0013a\u00029bG.\fw-Z\u0005\u0003\u0007\u0012\u0013aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u0002BMA\u0011a)S\u0007\u0002\u000f*\t\u0001*A\u0003tG\u0006d\u0017-\u0003\u0002K\u000f\n9\u0001K]8ek\u000e$\bC\u0001$M\u0013\tiuI\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0003mK\u001a$X#\u0001)\u0011\u0005U\n\u0016B\u0001*'\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\u0015QLW.\u001a.p]\u0016LE-F\u0001Y!\r1\u0015lW\u0005\u00035\u001e\u0013aa\u00149uS>t\u0007C\u0001/d\u001d\ti\u0016\r\u0005\u0002_\u000f6\tqL\u0003\u0002ae\u00051AH]8pizJ!AY$\u0002\rA\u0013X\rZ3g\u0013\t!WM\u0001\u0004TiJLgn\u001a\u0006\u0003E\u001e\u000b1\u0002^5nKj{g.Z%eA\u00051A(\u001b8jiz\"B!\u001b6lYB\u0011Q\u0007\u0001\u0005\u0006\u001d\u001e\u0001\r\u0001\u0015\u0005\u0006)\u001e\u0001\r\u0001\u0015\u0005\b-\u001e\u0001\n\u00111\u0001Y)\rIgn\u001c\u0005\u0006\u001d\"\u0001\r\u0001\u0015\u0005\u0006)\"\u0001\r\u0001U\u0001\tI\u0006$\u0018\rV=qKV\t!\u000f\u0005\u0002tm6\tAO\u0003\u0002vU\u0005)A/\u001f9fg&\u0011q\u000f\u001e\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003i\u0004Ba_@\u0002\u00069\u0011AP \b\u0003=vL\u0011\u0001S\u0005\u0003\u0003\u001eKA!!\u0001\u0002\u0004\t\u00191+Z9\u000b\u0005\u0005;\u0005cA:\u0002\b%\u0019\u0011\u0011\u0002;\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017\u0001D<ji\"$\u0016.\\3[_:,G\u0003BA\b\u0003+\u00012!NA\t\u0013\r\t\u0019B\n\u0002\u0018)&lWMW8oK\u0006;\u0018M]3FqB\u0014Xm]:j_:DQAV\u0006A\u0002m\u000bAB\\;mYN\u000bg-Z#wC2$b!a\u0007\u0002\"\u0005\u0015\u0002c\u0001$\u0002\u001e%\u0019\u0011qD$\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002$1\u0001\r!a\u0007\u0002\u0013QLW.Z:uC6\u0004\bbBA\u0014\u0019\u0001\u0007\u00111D\u0001\u0007M>\u0014X.\u0019;\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u0017\u0003s\t\u0019\u0005\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019DJ\u0001\bG>$WmZ3o\u0013\u0011\t9$!\r\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u000f\u000e\u0001\u0004\ti$A\u0002dib\u0004B!a\f\u0002@%!\u0011\u0011IA\u0019\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0012\u000e\u0001\u0004\ti#\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003m\u000bABZ8s[\u0006$8\u000b\u001e:j]\u001e\f\u0011\"[:QCJ\u001c\u0018N\\4\u0016\u0005\u0005E\u0003c\u0001$\u0002T%\u0019\u0011QK$\u0003\u000f\t{w\u000e\\3b]\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006S\u0006m\u0013q\f\u0005\u0007\u0003;\n\u0002\u0019\u0001)\u0002\u000f9,w\u000fT3gi\"1\u0011\u0011M\tA\u0002A\u000b\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0004j\u0003O\nI'a\u001b\t\u000f9\u0013\u0002\u0013!a\u0001!\"9AK\u0005I\u0001\u0002\u0004\u0001\u0006b\u0002,\u0013!\u0003\u0005\r\u0001W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tHK\u0002Q\u0003gZ#!!\u001e\u0011\t\u0005]\u0014\u0011Q\u0007\u0003\u0003sRA!a\u001f\u0002~\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u007f:\u0015AC1o]>$\u0018\r^5p]&!\u00111QA=\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a#+\u0007a\u000b\u0019(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0003B!a%\u0002\u001e6\u0011\u0011Q\u0013\u0006\u0005\u0003/\u000bI*\u0001\u0003mC:<'BAAN\u0003\u0011Q\u0017M^1\n\u0007\u0011\f)*\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002$B\u0019a)!*\n\u0007\u0005\u001dvIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u001c\u00055\u0006\"CAX1\u0005\u0005\t\u0019AAR\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u0017\t\u0007\u0003o\u000bi,a\u0007\u000e\u0005\u0005e&bAA^\u000f\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0016\u0011\u0018\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002R\u0005\u0015\u0007\"CAX5\u0005\u0005\t\u0019AA\u000e\u0003\u0019)\u0017/^1mgR!\u0011\u0011KAf\u0011%\tykGA\u0001\u0002\u0004\tY\u0002K\f\u0001\u0003\u001f\f).a6\u0002\\\u0006u\u0017\u0011]Ar\u0003O\fI/!<\u0002pB\u0019Q'!5\n\u0007\u0005MgEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0017\u0001^0G+:\u001bu\f\u000b;j[\u0016\u001cH/Y7qY\u00012W\u000e^\u0015![\u0001\u001auN\u001c<feR\u001c\b\u0005\u0019;j[\u0016\u001cH/Y7qA\u0002\"x\u000eI1!m\u0006dW/\u001a\u0011pM\u0002\u001aHO]5oO\u0002Jg\u000e\t;iK\u00022wN]7bi\u0002\u001a\b/Z2jM&,G\r\t2zAQDW\r\t3bi\u0016\u0004cm\u001c:nCR\u0004\u0003MZ7uA:\n\u0011\"\u0019:hk6,g\u000e^:\"\u0005\u0005}\u0017A!\u001c\u000bA\u0001\u0002\u0003%\u0011:hk6,g\u000e^:;\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"\u0018.\\3ti\u0006l\u0007\u000fI\u0017!\u0003\u0002\"\u0017\r^30i&lWm\u001d;b[B\u0004sN\u001d\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\rI2p]Z,'\u000f^3eAQ|\u0007\u0005\u001e5fA\u001dLg/\u001a8!M>\u0014X.\u0019;/\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u00012W\u000e\u001e\u0011.A\u0011\u000bG/Z\u0018uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014h\u000e\t;pA\u0019|G\u000e\\8x]\u0001\u001aV-\u001a\u0011=C\u0002B'/\u001a4>E!$H\u000f]:;_=\u001a\b/\u0019:l]\u0005\u0004\u0018m\u00195f]=\u0014xm\f3pGN|C.\u0019;fgR|3/\u001d7.e\u00164W\u0006Z1uKRLW.Z\u0017qCR$XM\u001d8/QRlGN\t ECR,G/[7fAA\u000bG\u000f^3s]Ndt&\u0019 !M>\u0014\bE^1mS\u0012\u0004C-\u0019;f\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0005tG\r\t;j[\u0016\u0004cm\u001c:nCR\u0004\u0003/\u0019;uKJt7O\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002f\u00069%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00143aE2T\u0006\r\u001b.aa:C\u0006I\u0014zO%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002l\u0006qA-\u0019;fi&lWm\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAy\u0003\u0015\td&\u000e\u00181\u0003=!\u0015\r^3G_Jl\u0017\r^\"mCN\u001c\bCA\u001b\u001e'\u0011i\u0012\u0011`&\u0011\u0011\u0005m(\u0011\u0001)Q1&l!!!@\u000b\u0007\u0005}x)A\u0004sk:$\u0018.\\3\n\t\t\r\u0011Q \u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAA{\u0003!!xn\u0015;sS:<GCAAI\u0003\u0015\t\u0007\u000f\u001d7z)\u001dI'q\u0002B\t\u0005'AQA\u0014\u0011A\u0002ACQ\u0001\u0016\u0011A\u0002ACqA\u0016\u0011\u0011\u0002\u0003\u0007\u0001,A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0003\u001d)h.\u00199qYf$BAa\u0007\u0003$A!a)\u0017B\u000f!\u00191%q\u0004)Q1&\u0019!\u0011E$\u0003\rQ+\b\u000f\\34\u0011!\u0011)CIA\u0001\u0002\u0004I\u0017a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1B]3bIJ+7o\u001c7wKR\u0011!Q\u0006\t\u0005\u0003'\u0013y#\u0003\u0003\u00032\u0005U%AB(cU\u0016\u001cG\u000f")
public class DateFormatClass
extends BinaryExpression
implements TimestampFormatterHelper,
ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression left;
    private final Expression right;
    private final Option<String> timeZoneId;
    private transient Option<TimestampFormatter> formatterOption;
    private boolean resolved;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return DateFormatClass$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Expression, Expression, Option<String>>> unapply(DateFormatClass dateFormatClass) {
        return DateFormatClass$.MODULE$.unapply(dateFormatClass);
    }

    public static Option<String> apply$default$3() {
        return DateFormatClass$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Expression, Expression, Option<String>>, DateFormatClass> tupled() {
        return DateFormatClass$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<String>, DateFormatClass>>> curried() {
        return DateFormatClass$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean forTimestampNTZ() {
        return TimestampFormatterHelper.forTimestampNTZ$(this);
    }

    @Override
    public final TimestampFormatter getFormatter(String fmt) {
        return TimestampFormatterHelper.getFormatter$(this, fmt);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private Option<TimestampFormatter> formatterOption$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatterOption = TimestampFormatterHelper.formatterOption$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatterOption;
    }

    @Override
    public final Option<TimestampFormatter> formatterOption() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatterOption$lzycompute() : this.formatterOption;
    }

    private boolean resolved$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        DateFormatClass dateFormatClass = this;
        synchronized (dateFormatClass) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object timestamp, Object format) {
        TimestampFormatter formatter = (TimestampFormatter)this.formatterOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getFormatter(format.toString()));
        return UTF8String.fromString((String)formatter.format(BoxesRunTime.unboxToLong((Object)timestamp)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return (ExprCode)this.formatterOption().map((Function1 & Serializable & scala.Serializable)tf -> {
            String timestampFormatter = ctx.addReferenceObj("timestampFormatter", tf, ctx.addReferenceObj$default$3());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, x$1) -> new StringBuilder(32).append("UTF8String.fromString(").append(timestampFormatter).append(".format(").append((String)timestamp).append("))").toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String tf = new StringOps(Predef$.MODULE$.augmentString(TimestampFormatter$.MODULE$.getClass().getName())).stripSuffix("$");
            String ldf = new StringOps(Predef$.MODULE$.augmentString(LegacyDateFormats$.MODULE$.getClass().getName())).stripSuffix("$");
            String zid = ctx.addReferenceObj("zoneId", this.zoneId(), ZoneId.class.getName());
            return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(timestamp, format) -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("|UTF8String.fromString(").append(tf).append("$.MODULE$.apply(\n            |  ").append((String)format).append(".toString(),\n            |  ").append(zid).append(",\n            |  ").append(ldf).append("$.MODULE$.SIMPLE_DATE_FORMAT(),\n            |  false)\n            |.format(").append((String)timestamp).append("))").toString())).stripMargin());
        });
    }

    @Override
    public String prettyName() {
        return "date_format";
    }

    @Override
    public Expression formatString() {
        return this.right();
    }

    @Override
    public boolean isParsing() {
        return false;
    }

    @Override
    public DateFormatClass withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight, this.copy$default$3());
    }

    public DateFormatClass copy(Expression left, Expression right, Option<String> timeZoneId) {
        return new DateFormatClass(left, right, timeZoneId);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "DateFormatClass";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<String> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.left();
                break;
            }
            case 1: {
                option = this.right();
                break;
            }
            case 2: {
                option = this.timeZoneId();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DateFormatClass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DateFormatClass)) return false;
        boolean bl = true;
        if (!bl) return false;
        DateFormatClass dateFormatClass = (DateFormatClass)x$1;
        Expression expression = this.left();
        Expression expression2 = dateFormatClass.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = dateFormatClass.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = dateFormatClass.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!dateFormatClass.canEqual(this)) return false;
        return true;
    }

    public DateFormatClass(Expression left, Expression right, Option<String> timeZoneId) {
        this.left = left;
        this.right = right;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        TimestampFormatterHelper.$init$(this);
        ExpectsInputTypes.$init$(this);
    }

    public DateFormatClass(Expression left, Expression right) {
        this(left, right, (Option<String>)None$.MODULE$);
    }
}

