/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.utils;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.amoro.IcebergFileEntry;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.TableFormat;
import org.apache.amoro.api.CommitMetaProducer;
import org.apache.amoro.config.OptimizingConfig;
import org.apache.amoro.hive.optimizing.plan.MixedHiveOptimizingEvaluator;
import org.apache.amoro.hive.optimizing.plan.MixedHiveOptimizingPlanner;
import org.apache.amoro.optimizing.plan.AbstractOptimizingEvaluator;
import org.apache.amoro.optimizing.plan.AbstractOptimizingPlanner;
import org.apache.amoro.optimizing.plan.IcebergOptimizerEvaluator;
import org.apache.amoro.optimizing.plan.IcebergOptimizingPlanner;
import org.apache.amoro.optimizing.plan.MixedIcebergOptimizingEvaluator;
import org.apache.amoro.optimizing.plan.MixedIcebergOptimizingPlanner;
import org.apache.amoro.scan.TableEntriesScan;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.amoro.shade.guava32.com.google.common.base.Predicate;
import org.apache.amoro.shade.guava32.com.google.common.collect.Iterables;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.shade.guava32.com.google.common.collect.Sets;
import org.apache.amoro.table.BasicTableSnapshot;
import org.apache.amoro.table.KeyedTableSnapshot;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.TableSnapshot;
import org.apache.amoro.utils.ExpressionUtil;
import org.apache.amoro.utils.TableFileUtil;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.ReachableFileUtil;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.True;
import org.apache.iceberg.io.CloseableIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergTableUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergTableUtil.class);

    public static long getSnapshotId(Table table, boolean refresh) {
        Snapshot currentSnapshot = IcebergTableUtil.getSnapshot(table, refresh);
        if (currentSnapshot == null) {
            return -1L;
        }
        return currentSnapshot.snapshotId();
    }

    public static TableSnapshot getSnapshot(MixedTable mixedTable, TableRuntime tableRuntime) {
        if (mixedTable.isUnkeyedTable()) {
            return new BasicTableSnapshot(tableRuntime.getCurrentSnapshotId());
        }
        return new KeyedTableSnapshot(tableRuntime.getCurrentSnapshotId(), tableRuntime.getCurrentChangeSnapshotId());
    }

    public static Snapshot getSnapshot(Table table, boolean refresh) {
        if (refresh) {
            table.refresh();
        }
        return table.currentSnapshot();
    }

    public static Optional<Snapshot> findFirstMatchSnapshot(Table table, Predicate<Snapshot> predicate) {
        ArrayList snapshots = Lists.newArrayList((Iterable)table.snapshots());
        Collections.reverse(snapshots);
        return Optional.ofNullable(Iterables.tryFind((Iterable)snapshots, predicate).orNull());
    }

    public static Optional<Snapshot> findLatestOptimizingSnapshot(Table table) {
        return IcebergTableUtil.findFirstMatchSnapshot(table, (Predicate<Snapshot>)((Predicate)snapshot -> snapshot.summary().containsValue(CommitMetaProducer.OPTIMIZE.name()) && "replace".equals(snapshot.operation())));
    }

    public static Set<String> getAllContentFilePath(Table internalTable) {
        HashSet<String> validFilesPath = new HashSet<String>();
        TableEntriesScan entriesScan = TableEntriesScan.builder((Table)internalTable).includeFileContent(new FileContent[]{FileContent.DATA, FileContent.POSITION_DELETES, FileContent.EQUALITY_DELETES}).allEntries().build();
        try (CloseableIterable entries = entriesScan.entries();){
            for (IcebergFileEntry entry : entries) {
                validFilesPath.add(TableFileUtil.getUriPath((String)entry.getFile().path().toString()));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return validFilesPath;
    }

    public static Set<String> getAllStatisticsFilePath(Table table) {
        return ReachableFileUtil.statisticsFilesLocations((Table)table).stream().map(TableFileUtil::getUriPath).collect(Collectors.toSet());
    }

    public static Set<DeleteFile> getDanglingDeleteFiles(Table internalTable) {
        if (internalTable.currentSnapshot() == null) {
            return Collections.emptySet();
        }
        long snapshotId = internalTable.currentSnapshot().snapshotId();
        HashSet<String> deleteFilesPath = new HashSet<String>();
        TableScan tableScan = internalTable.newScan().useSnapshot(snapshotId);
        try (CloseableIterable fileScanTasks = tableScan.planFiles();){
            for (FileScanTask fileScanTask : fileScanTasks) {
                for (DeleteFile delete : fileScanTask.deletes()) {
                    deleteFilesPath.add(delete.path().toString());
                }
            }
        }
        catch (IOException e) {
            LOG.error("table scan plan files error", (Throwable)e);
            return Collections.emptySet();
        }
        HashSet<DeleteFile> danglingDeleteFiles = new HashSet<DeleteFile>();
        TableEntriesScan entriesScan = TableEntriesScan.builder((Table)internalTable).useSnapshot(snapshotId).includeFileContent(new FileContent[]{FileContent.EQUALITY_DELETES, FileContent.POSITION_DELETES}).build();
        try (CloseableIterable entries = entriesScan.entries();){
            for (IcebergFileEntry entry : entries) {
                ContentFile file = entry.getFile();
                String path = file.path().toString();
                if (deleteFilesPath.contains(path)) continue;
                danglingDeleteFiles.add((DeleteFile)file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error when fetch iceberg entries", e);
        }
        return danglingDeleteFiles;
    }

    public static Set<String> getAllManifestFiles(Table table) {
        Preconditions.checkArgument((boolean)(table instanceof HasTableOperations), (Object)"the table must support table operation.");
        TableOperations ops = ((HasTableOperations)table).operations();
        Table allManifest = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)table.name(), (String)(table.name() + "#" + MetadataTableType.ALL_MANIFESTS.name()), (MetadataTableType)MetadataTableType.ALL_MANIFESTS);
        Set allManifestFiles = Sets.newConcurrentHashSet();
        TableScan scan = (TableScan)allManifest.newScan().select(new String[]{"path"});
        CloseableIterable tasks = scan.planFiles();
        CloseableIterable transform = CloseableIterable.transform((CloseableIterable)tasks, task -> task.asDataTask().rows());
        try (CloseableIterable rows = CloseableIterable.concat((Iterable)transform);){
            rows.forEach(r -> allManifestFiles.add(r.get(0, String.class)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return allManifestFiles;
    }

    public static AbstractOptimizingEvaluator createOptimizingEvaluator(TableRuntime tableRuntime, MixedTable table, TableSnapshot snapshot, int maxPendingPartitions) {
        ServerTableIdentifier identifier = tableRuntime.getTableIdentifier();
        OptimizingConfig config = tableRuntime.getOptimizingConfig();
        long lastMinor = tableRuntime.getLastMinorOptimizingTime();
        long lastFull = tableRuntime.getLastFullOptimizingTime();
        if (TableFormat.ICEBERG.equals((Object)table.format())) {
            return new IcebergOptimizerEvaluator(identifier, config, table, snapshot, maxPendingPartitions, lastMinor, lastFull);
        }
        if (TableFormat.MIXED_ICEBERG.equals((Object)table.format())) {
            return new MixedIcebergOptimizingEvaluator(identifier, config, table, snapshot, maxPendingPartitions, lastMinor, lastFull);
        }
        if (TableFormat.MIXED_HIVE.equals((Object)table.format())) {
            return new MixedHiveOptimizingEvaluator(identifier, config, table, snapshot, maxPendingPartitions, lastMinor, lastFull);
        }
        throw new IllegalStateException("Un-supported table-format:" + table.format().toString());
    }

    public static AbstractOptimizingEvaluator createOptimizingEvaluator(TableRuntime tableRuntime, MixedTable table, int maxPendingPartitions) {
        TableSnapshot snapshot = IcebergTableUtil.getSnapshot(table, tableRuntime);
        return IcebergTableUtil.createOptimizingEvaluator(tableRuntime, table, snapshot, maxPendingPartitions);
    }

    public static AbstractOptimizingPlanner createOptimizingPlanner(TableRuntime tableRuntime, MixedTable table, double availableCore, long maxInputSizePerThread) {
        True partitionFilter = tableRuntime.getPendingInput() == null ? Expressions.alwaysTrue() : tableRuntime.getPendingInput().getPartitions().entrySet().stream().map(entry -> ExpressionUtil.convertPartitionDataToDataFilter((MixedTable)table, (int)((Integer)entry.getKey()), (Collection)((Collection)entry.getValue()))).reduce(Expressions::or).orElse((Expression)Expressions.alwaysTrue());
        long planTime = System.currentTimeMillis();
        long processId = Math.max(tableRuntime.getNewestProcessId() + 1L, planTime);
        ServerTableIdentifier identifier = tableRuntime.getTableIdentifier();
        OptimizingConfig config = tableRuntime.getOptimizingConfig();
        long lastMinor = tableRuntime.getLastMinorOptimizingTime();
        long lastFull = tableRuntime.getLastFullOptimizingTime();
        TableSnapshot snapshot = IcebergTableUtil.getSnapshot(table, tableRuntime);
        if (TableFormat.ICEBERG.equals((Object)table.format())) {
            return new IcebergOptimizingPlanner(identifier, config, table, snapshot, (Expression)partitionFilter, processId, availableCore, maxInputSizePerThread, lastMinor, lastFull);
        }
        if (TableFormat.MIXED_ICEBERG.equals((Object)table.format())) {
            return new MixedIcebergOptimizingPlanner(identifier, config, table, snapshot, (Expression)partitionFilter, processId, availableCore, maxInputSizePerThread, lastMinor, lastFull);
        }
        if (TableFormat.MIXED_HIVE.equals((Object)table.format())) {
            return new MixedHiveOptimizingPlanner(identifier, config, table, snapshot, (Expression)partitionFilter, processId, availableCore, maxInputSizePerThread, lastMinor, lastFull);
        }
        throw new IllegalStateException("Unsupported table format:" + table.format().toString());
    }
}

