/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.table.executor;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.amoro.AmoroTable;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.config.TableConfiguration;
import org.apache.amoro.server.optimizing.OptimizingStatus;
import org.apache.amoro.server.table.RuntimeHandlerChain;
import org.apache.amoro.server.table.TableRuntime;
import org.apache.amoro.server.table.TableService;
import org.apache.amoro.shade.guava32.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseTableExecutor
extends RuntimeHandlerChain {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long START_DELAY = 10000L;
    private final ScheduledExecutorService executor;
    private final TableService tableService;
    private final Set<ServerTableIdentifier> scheduledTables = Collections.synchronizedSet(new HashSet());

    protected BaseTableExecutor(TableService tableService, int poolSize) {
        this.tableService = tableService;
        this.executor = Executors.newScheduledThreadPool(poolSize, new ThreadFactoryBuilder().setDaemon(false).setNameFormat("async-" + this.getThreadName() + "-%d").build());
    }

    @Override
    protected void initHandler(List<TableRuntime> tableRuntimeList) {
        tableRuntimeList.stream().filter(this::enabled).forEach(tableRuntime -> {
            if (this.scheduledTables.add(tableRuntime.getTableIdentifier())) {
                this.executor.schedule(() -> this.executeTask((TableRuntime)tableRuntime), this.getStartDelay(), TimeUnit.MILLISECONDS);
            }
        });
        this.logger.info("Table executor {} initialized", (Object)this.getClass().getSimpleName());
    }

    private void executeTask(TableRuntime tableRuntime) {
        try {
            if (this.isExecutable(tableRuntime)) {
                this.execute(tableRuntime);
            }
        }
        finally {
            this.scheduledTables.remove(tableRuntime.getTableIdentifier());
            this.scheduleIfNecessary(tableRuntime, this.getNextExecutingTime(tableRuntime));
        }
    }

    protected final void scheduleIfNecessary(TableRuntime tableRuntime, long millisecondsTime) {
        if (this.isExecutable(tableRuntime) && this.scheduledTables.add(tableRuntime.getTableIdentifier())) {
            this.executor.schedule(() -> this.executeTask(tableRuntime), millisecondsTime, TimeUnit.MILLISECONDS);
        }
    }

    protected abstract long getNextExecutingTime(TableRuntime var1);

    protected abstract boolean enabled(TableRuntime var1);

    protected abstract void execute(TableRuntime var1);

    protected String getThreadName() {
        return String.join((CharSequence)"-", StringUtils.splitByCharacterTypeCamelCase((String)this.getClass().getSimpleName())).toLowerCase(Locale.ROOT);
    }

    private boolean isExecutable(TableRuntime tableRuntime) {
        return this.tableService.contains(tableRuntime.getTableIdentifier().getId()) && this.enabled(tableRuntime);
    }

    @Override
    public void handleConfigChanged(TableRuntime tableRuntime, TableConfiguration originalConfig) {
    }

    @Override
    public void handleTableRemoved(TableRuntime tableRuntime) {
    }

    @Override
    public void handleStatusChanged(TableRuntime tableRuntime, OptimizingStatus originalStatus) {
    }

    @Override
    public void handleTableAdded(AmoroTable<?> table, TableRuntime tableRuntime) {
        this.scheduleIfNecessary(tableRuntime, this.getStartDelay());
    }

    @Override
    protected void doDispose() {
        this.executor.shutdownNow();
        this.logger.info("dispose thread pool for threads {}", (Object)this.getThreadName());
    }

    protected long getStartDelay() {
        return 10000L;
    }

    protected AmoroTable<?> loadTable(TableRuntime tableRuntime) {
        return this.tableService.loadTable(tableRuntime.getTableIdentifier());
    }
}

