/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.persistence;

import java.io.Closeable;
import java.util.function.Supplier;
import org.apache.amoro.shade.guava32.com.google.common.annotations.VisibleForTesting;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;
import org.apache.ibatis.session.SqlSession;

public final class NestedSqlSession
implements Closeable {
    @VisibleForTesting
    private static final int MAX_NEST_BEGIN_COUNT = 5;
    @VisibleForTesting
    private static final ThreadLocal<NestedSqlSession> sessions = new ThreadLocal();
    private int nestCount = 0;
    private boolean isRollingback = false;
    private SqlSession sqlSession;

    public static NestedSqlSession openSession(Supplier<SqlSession> sessionSupplier) {
        NestedSqlSession session = sessions.get();
        if (session == null) {
            sessions.set(new NestedSqlSession(sessionSupplier.get()));
            return sessions.get();
        }
        return session.openNestedSession();
    }

    SqlSession getSqlSession() {
        return this.sqlSession;
    }

    @VisibleForTesting
    NestedSqlSession(SqlSession sqlSession) {
        this.sqlSession = sqlSession;
    }

    NestedSqlSession openNestedSession() {
        this.checkState(true);
        Preconditions.checkState((this.nestCount < 5 && this.nestCount >= 0 ? 1 : 0) != 0, (Object)("openNestedSession() has not been properly called for nest count is " + this.nestCount));
        ++this.nestCount;
        return this;
    }

    public void commit() {
        this.checkState(true);
        if (this.nestCount == 0) {
            this.sqlSession.commit(true);
        }
    }

    public void rollback() {
        this.checkState(false);
        this.isRollingback = true;
        if (this.nestCount == 0) {
            this.sqlSession.rollback(true);
            this.isRollingback = false;
        }
    }

    private void checkState(boolean checkRollingback) {
        Preconditions.checkState((this.sqlSession != null ? 1 : 0) != 0, (Object)"session already closed");
        if (checkRollingback) {
            Preconditions.checkState((!this.isRollingback ? 1 : 0) != 0, (Object)"session is rolling back, can not execute operation");
        }
    }

    @Override
    public void close() {
        if (this.nestCount > 0) {
            --this.nestCount;
        } else if (this.nestCount == 0 && this.sqlSession != null) {
            this.sqlSession.close();
            this.sqlSession = null;
            sessions.remove();
            this.nestCount = -1;
        }
    }
}

