/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.server.catalog;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.amoro.ServerTableIdentifier;
import org.apache.amoro.TableFormat;
import org.apache.amoro.TableIDWithFormat;
import org.apache.amoro.api.CatalogMeta;
import org.apache.amoro.exception.AlreadyExistsException;
import org.apache.amoro.exception.IllegalMetadataException;
import org.apache.amoro.exception.ObjectNotExistsException;
import org.apache.amoro.server.catalog.ServerCatalog;
import org.apache.amoro.server.persistence.mapper.CatalogMetaMapper;
import org.apache.amoro.server.persistence.mapper.TableBlockerMapper;
import org.apache.amoro.server.persistence.mapper.TableMetaMapper;
import org.apache.amoro.server.table.TableMetadata;
import org.apache.amoro.server.table.internal.InternalTableCreator;
import org.apache.amoro.server.table.internal.InternalTableHandler;
import org.apache.amoro.table.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateTableRequest;

public abstract class InternalCatalog
extends ServerCatalog {
    protected InternalCatalog(CatalogMeta metadata) {
        super(metadata);
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public List<String> listDatabases() {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectDatabases(this.getMetadata().getCatalogName()));
    }

    public void createDatabase(String databaseName) {
        if (this.databaseExists(databaseName)) {
            throw new AlreadyExistsException("Database " + databaseName);
        }
        this.doAsTransaction(() -> this.doAsExisted(CatalogMetaMapper.class, mapper -> mapper.incDatabaseCount(1, this.name()), () -> new ObjectNotExistsException("Catalog " + this.name())), () -> this.doAs(TableMetaMapper.class, mapper -> mapper.insertDatabase(this.getMetadata().getCatalogName(), databaseName)), () -> this.createDatabaseInternal(databaseName));
    }

    public void dropDatabase(String databaseName) {
        if (!this.databaseExists(databaseName)) {
            throw new ObjectNotExistsException("Database " + databaseName);
        }
        this.doAsTransaction(() -> this.doAsExisted(TableMetaMapper.class, mapper -> mapper.dropDb(this.getMetadata().getCatalogName(), databaseName), () -> new IllegalMetadataException("Database " + databaseName + " has more than one table")), () -> this.dropDatabaseInternal(databaseName), () -> this.doAsExisted(CatalogMetaMapper.class, mapper -> mapper.decDatabaseCount(1, this.name()), () -> new ObjectNotExistsException(this.name())));
    }

    @Override
    public List<TableIDWithFormat> listTables(String database) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifiersByDb(this.getMetadata().getCatalogName(), database)).stream().map(sid -> TableIDWithFormat.of((TableIdentifier)sid.getIdentifier(), (TableFormat)sid.getFormat())).collect(Collectors.toList());
    }

    @Override
    public List<TableIDWithFormat> listTables() {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifiersByCatalog(this.getMetadata().getCatalogName())).stream().map(sid -> TableIDWithFormat.of((TableIdentifier)sid.getIdentifier(), (TableFormat)sid.getFormat())).collect(Collectors.toList());
    }

    public abstract InternalTableCreator newTableCreator(String var1, String var2, TableFormat var3, CreateTableRequest var4);

    public abstract <O> InternalTableHandler<O> newTableHandler(String var1, String var2);

    public TableMetadata createTable(TableMetadata tableMetadata) {
        this.validateTableIdentifier(tableMetadata.getTableIdentifier().getIdentifier());
        ServerTableIdentifier tableIdentifier = tableMetadata.getTableIdentifier();
        this.doAsTransaction(() -> this.doAs(TableMetaMapper.class, mapper -> mapper.insertTable(tableIdentifier)), () -> this.doAs(TableMetaMapper.class, mapper -> mapper.insertTableMeta(tableMetadata)), () -> this.doAsExisted(CatalogMetaMapper.class, mapper -> mapper.incTableCount(1, this.name()), () -> new ObjectNotExistsException(this.name())), () -> this.increaseDatabaseTableCount(tableIdentifier.getDatabase()));
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaByName(tableIdentifier.getCatalog(), tableIdentifier.getDatabase(), tableIdentifier.getTableName()));
    }

    public ServerTableIdentifier dropTable(String databaseName, String tableName) {
        ServerTableIdentifier tableIdentifier = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifier(this.getMetadata().getCatalogName(), databaseName, tableName));
        if (tableIdentifier.getId() == null) {
            throw new ObjectNotExistsException(this.getTableDesc(databaseName, tableName));
        }
        this.doAsTransaction(() -> this.doAsExisted(TableMetaMapper.class, mapper -> mapper.deleteTableIdById(tableIdentifier.getId()), () -> new ObjectNotExistsException(this.getTableDesc(databaseName, tableName))), () -> this.doAs(TableMetaMapper.class, mapper -> mapper.deleteTableMetaById(tableIdentifier.getId())), () -> this.doAs(TableBlockerMapper.class, mapper -> mapper.deleteTableBlockers(this.name(), databaseName, tableName)), () -> this.dropTableInternal(databaseName, tableName), () -> this.doAsExisted(CatalogMetaMapper.class, mapper -> mapper.decTableCount(1, tableIdentifier.getCatalog()), () -> new ObjectNotExistsException(this.name())), () -> this.decreaseDatabaseTableCount(tableIdentifier.getDatabase()));
        return tableIdentifier;
    }

    @Override
    public boolean databaseExists(String database) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectDatabase(this.getMetadata().getCatalogName(), database)) != null;
    }

    @Override
    public boolean tableExists(String database, String tableName) {
        ServerTableIdentifier tableIdentifier = this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableIdentifier(this.getMetadata().getCatalogName(), database, tableName));
        return tableIdentifier != null && this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaById(tableIdentifier.getId())) != null;
    }

    public TableMetadata loadTableMetadata(String database, String table) {
        return Optional.ofNullable(this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetaByName(this.name(), database, table))).orElseThrow(() -> new ObjectNotExistsException(TableIdentifier.of((String)this.name(), (String)database, (String)table).toString()));
    }

    public List<TableMetadata> listTableMetadataInDatabase(String database) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableMetasByDb(this.name(), database));
    }

    private String getDatabaseDesc(String database) {
        return this.name() + '.' + database;
    }

    protected String getTableDesc(String database, String tableName) {
        return this.name() + '.' + database + '.' + tableName;
    }

    public Integer getTableCount() {
        return this.getAs(CatalogMetaMapper.class, mapper -> mapper.selectTableCount(this.name()));
    }

    public Integer getTableCount(String databaseName) {
        return this.getAs(TableMetaMapper.class, mapper -> mapper.selectTableCount(this.name()));
    }

    protected void decreaseDatabaseTableCount(String databaseName) {
        this.doAsExisted(TableMetaMapper.class, mapper -> mapper.decTableCount(1, databaseName), () -> new ObjectNotExistsException(this.getDatabaseDesc(databaseName)));
    }

    protected void increaseDatabaseTableCount(String databaseName) {
        this.doAsExisted(TableMetaMapper.class, mapper -> mapper.incTableCount(1, databaseName), () -> new ObjectNotExistsException(this.getDatabaseDesc(databaseName)));
    }

    protected void createDatabaseInternal(String databaseName) {
    }

    protected void dropTableInternal(String databaseName, String tableName) {
    }

    protected void dropDatabaseInternal(String databaseName) {
    }

    protected void validateTableIdentifier(TableIdentifier tableIdentifier) {
        if (!this.name().equals(tableIdentifier.getCatalog())) {
            throw new IllegalMetadataException("Catalog name is error in table identifier");
        }
    }
}

