/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.reader;

import java.util.Map;
import java.util.function.Function;
import org.apache.amoro.hive.io.reader.AbstractAdaptHiveUnkeyedDataReader;
import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.spark.SparkInternalRowWrapper;
import org.apache.amoro.spark.reader.SparkParquetReaders;
import org.apache.amoro.spark.util.MixedFormatSparkUtils;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.orc.OrcRowReader;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.data.SparkOrcReader;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class SparkUnkeyedDataReader
extends AbstractAdaptHiveUnkeyedDataReader<InternalRow> {
    public SparkUnkeyedDataReader(AuthenticatedFileIO fileIO, Schema tableSchema, Schema projectedSchema, String nameMapping, boolean caseSensitive) {
        super(fileIO, tableSchema, projectedSchema, nameMapping, caseSensitive, MixedFormatSparkUtils::convertConstant, true);
    }

    protected Function<MessageType, ParquetValueReader<?>> getParquetReaderFunction(Schema projectedSchema, Map<Integer, ?> idToConstant) {
        return fileSchema -> SparkParquetReaders.buildReader(projectedSchema, fileSchema, idToConstant);
    }

    protected Function<TypeDescription, OrcRowReader<?>> getOrcReaderFunction(Schema projectSchema, Map<Integer, ?> idToConstant) {
        return fileSchema -> new SparkOrcReader(projectSchema, fileSchema, idToConstant);
    }

    protected Function<Schema, Function<InternalRow, StructLike>> toStructLikeFunction() {
        return schema -> {
            StructType structType = SparkSchemaUtil.convert((Schema)schema);
            SparkInternalRowWrapper wrapper = new SparkInternalRowWrapper(structType);
            return row -> wrapper.wrap((InternalRow)row);
        };
    }
}

