/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.spark.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.amoro.data.ChangeAction;
import org.apache.amoro.io.writer.OutputFileFactory;
import org.apache.amoro.io.writer.SortedPosDeleteWriter;
import org.apache.amoro.shade.guava32.com.google.common.collect.Lists;
import org.apache.amoro.spark.SparkInternalRowCastWrapper;
import org.apache.amoro.spark.SparkInternalRowWrapper;
import org.apache.amoro.spark.io.SparkBaseTaskWriter;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataTypes;

public class UnkeyedUpsertSparkWriter<T>
implements TaskWriter<T> {
    private final List<DeleteFile> completedDeleteFiles = Lists.newArrayList();
    private final List<DataFile> completedDataFiles = Lists.newArrayList();
    private final FileAppenderFactory<InternalRow> appenderFactory;
    private final OutputFileFactory fileFactory;
    private final FileFormat format;
    private final Schema schema;
    private final MixedTable table;
    private final SparkBaseTaskWriter writer;
    private final Map<PartitionKey, SortedPosDeleteWriter<InternalRow>> writerMap = new HashMap<PartitionKey, SortedPosDeleteWriter<InternalRow>>();
    private boolean closed = false;

    public UnkeyedUpsertSparkWriter(MixedTable table, FileAppenderFactory<InternalRow> appenderFactory, OutputFileFactory fileFactory, FileFormat format, Schema schema, SparkBaseTaskWriter writer) {
        this.table = table;
        this.appenderFactory = appenderFactory;
        this.fileFactory = fileFactory;
        this.format = format;
        this.schema = schema;
        this.writer = writer;
    }

    public void write(T row) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Pos-delete writer for table " + this.table.id().toString() + " already closed");
        }
        SparkInternalRowCastWrapper internalRow = (SparkInternalRowCastWrapper)((Object)row);
        SparkInternalRowWrapper structLike = new SparkInternalRowWrapper(SparkSchemaUtil.convert((Schema)this.schema)).wrap(internalRow.getRow());
        PartitionKey partitionKey = new PartitionKey(this.table.spec(), this.schema);
        partitionKey.partition((StructLike)structLike);
        if (this.writerMap.get(partitionKey) == null) {
            SortedPosDeleteWriter writer = new SortedPosDeleteWriter(this.appenderFactory, this.fileFactory, this.table.io(), this.format, (StructLike)partitionKey);
            this.writerMap.putIfAbsent(partitionKey, (SortedPosDeleteWriter<InternalRow>)writer);
        }
        if (internalRow.getChangeAction() == ChangeAction.DELETE) {
            SortedPosDeleteWriter<InternalRow> deleteWriter = this.writerMap.get(partitionKey);
            int numFields = internalRow.getRow().numFields();
            Object file = internalRow.getRow().get(numFields - 2, DataTypes.StringType);
            Object pos = internalRow.getRow().get(numFields - 1, DataTypes.IntegerType);
            deleteWriter.delete((CharSequence)file.toString(), Long.parseLong(pos.toString()), null);
        } else {
            this.writer.write(internalRow.getRow());
        }
    }

    public void abort() throws IOException {
        this.close();
    }

    public WriteResult complete() throws IOException {
        for (Map.Entry<PartitionKey, SortedPosDeleteWriter<InternalRow>> entry : this.writerMap.entrySet()) {
            this.completedDeleteFiles.addAll(entry.getValue().complete());
        }
        this.close();
        this.completedDataFiles.addAll(Arrays.asList(this.writer.complete().dataFiles()));
        return WriteResult.builder().addDeleteFiles(this.completedDeleteFiles).addDataFiles(this.completedDataFiles).build();
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

