/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import net.sf.jsqlparser.statement.select.GroupByVisitor;
import net.sf.jsqlparser.statement.select.Select;

public class GroupByElement
implements Serializable {
    private ExpressionList groupByExpressions = new ExpressionList(new Expression[0]);
    private List<ExpressionList> groupingSets = new ArrayList<ExpressionList>();

    public boolean isUsingBrackets() {
        return this.groupByExpressions.isUsingBrackets();
    }

    public void accept(GroupByVisitor groupByVisitor) {
        groupByVisitor.visit(this);
    }

    public ExpressionList getGroupByExpressionList() {
        return this.groupByExpressions;
    }

    public void setGroupByExpressions(ExpressionList groupByExpressions) {
        this.groupByExpressions = groupByExpressions;
    }

    @Deprecated
    public ExpressionList getGroupByExpressions() {
        return this.groupByExpressions;
    }

    @Deprecated
    public void addGroupByExpression(Expression groupByExpression) {
        if (this.groupByExpressions.getExpressions() == null) {
            this.groupByExpressions.setExpressions(new ArrayList());
        }
        this.groupByExpressions.getExpressions().add(groupByExpression);
    }

    public List<ExpressionList> getGroupingSets() {
        return this.groupingSets;
    }

    public void setGroupingSets(List<ExpressionList> groupingSets) {
        this.groupingSets = groupingSets;
    }

    public void addGroupingSet(ExpressionList list) {
        this.groupingSets.add(list);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("GROUP BY ");
        if (this.groupByExpressions != null) {
            b.append(this.groupByExpressions.toString());
        }
        int i = 0;
        if (this.groupingSets.size() > 0) {
            if (b.charAt(b.length() - 1) != ' ') {
                b.append(' ');
            }
            b.append("GROUPING SETS (");
            for (ExpressionList expressionList : this.groupingSets) {
                b.append(i++ > 0 ? ", " : "").append(Select.getStringList(expressionList, true, expressionList instanceof ParenthesedExpressionList));
            }
            b.append(")");
        }
        return b.toString();
    }

    public GroupByElement withGroupByExpressions(ExpressionList groupByExpressions) {
        this.setGroupByExpressions(groupByExpressions);
        return this;
    }

    public GroupByElement withGroupingSets(List groupingSets) {
        this.setGroupingSets(groupingSets);
        return this;
    }

    public GroupByElement addGroupByExpressions(Expression ... groupByExpressions) {
        return this.addGroupByExpressions(Arrays.asList(groupByExpressions));
    }

    public GroupByElement addGroupByExpressions(Collection<? extends Expression> groupByExpressions) {
        ExpressionList collection = Optional.ofNullable(this.getGroupByExpressions()).orElseGet(() -> new ExpressionList(new Expression[0]));
        Collections.addAll(collection, groupByExpressions);
        return this.withGroupByExpressions(collection);
    }

    public GroupByElement addGroupingSets(Object ... groupingSets) {
        List collection = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        Collections.addAll(collection, groupingSets);
        return this.withGroupingSets(collection);
    }

    public GroupByElement addGroupingSets(Collection<? extends Object> groupingSets) {
        List collection = Optional.ofNullable(this.getGroupingSets()).orElseGet(ArrayList::new);
        collection.addAll(groupingSets);
        return this.withGroupingSets(collection);
    }
}

