/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.source.SparkBatch;
import org.apache.iceberg.spark.source.SparkMicroBatchStream;
import org.apache.iceberg.spark.source.Stats;
import org.apache.iceberg.spark.source.metrics.NumDeletes;
import org.apache.iceberg.spark.source.metrics.NumSplits;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkScan
implements Scan,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(SparkScan.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private final boolean readTimestampWithoutZone;
    private final String branch;
    private StructType readSchema;

    SparkScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters) {
        Schema snapshotSchema = SnapshotUtil.schemaFor((Table)table, (String)readConf.branch());
        SparkSchemaUtil.validateMetadataColumnReferences(snapshotSchema, expectedSchema);
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.readConf = readConf;
        this.caseSensitive = readConf.caseSensitive();
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters != null ? filters : Collections.emptyList();
        this.readTimestampWithoutZone = readConf.handleTimestampWithoutZone();
        this.branch = readConf.branch();
    }

    protected Table table() {
        return this.table;
    }

    protected String branch() {
        return this.branch;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    protected Types.StructType groupingKeyType() {
        return Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
    }

    protected abstract List<? extends ScanTaskGroup<?>> taskGroups();

    public Batch toBatch() {
        return new SparkBatch(this.sparkContext, this.table, this.readConf, this.groupingKeyType(), this.taskGroups(), this.expectedSchema, this.hashCode());
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return new SparkMicroBatchStream(this.sparkContext, this.table, this.readConf, this.expectedSchema, checkpointLocation);
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            Preconditions.checkArgument((this.readTimestampWithoutZone || !SparkUtil.hasTimestampWithoutZone(this.expectedSchema) ? 1 : 0) != 0, (Object)SparkUtil.TIMESTAMP_WITHOUT_TIMEZONE_ERROR);
            this.readSchema = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.readSchema;
    }

    public Statistics estimateStatistics() {
        return this.estimateStatistics(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
    }

    protected Statistics estimateStatistics(Snapshot snapshot) {
        if (snapshot == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("Using snapshot {} metadata to estimate statistics for table {}", (Object)snapshot.snapshotId(), (Object)this.table.name());
            long totalRecords = this.totalRecords(snapshot);
            return new Stats(SparkSchemaUtil.estimateSize(this.readSchema(), totalRecords), totalRecords);
        }
        long rowsCount = this.taskGroups().stream().mapToLong(ScanTaskGroup::estimatedRowsCount).sum();
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), rowsCount);
        return new Stats(sizeInBytes, rowsCount);
    }

    private long totalRecords(Snapshot snapshot) {
        Map summary = snapshot.summary();
        return PropertyUtil.propertyAsLong((Map)summary, (String)"total-records", (long)Long.MAX_VALUE);
    }

    public String description() {
        String groupingKeyFieldNamesAsString = this.groupingKeyType().fields().stream().map(Types.NestedField::name).collect(Collectors.joining(", "));
        return String.format("%s (branch=%s) [filters=%s, groupedBy=%s]", this.table(), this.branch(), Spark3Util.describe(this.filterExpressions), groupingKeyFieldNamesAsString);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return new CustomMetric[]{new NumSplits(), new NumDeletes()};
    }
}

