/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.read.LocalScan;
import org.apache.spark.sql.types.StructType;

class SparkLocalScan
implements LocalScan {
    private final Table table;
    private final StructType readSchema;
    private final InternalRow[] rows;
    private final List<Expression> filterExpressions;

    SparkLocalScan(Table table, StructType readSchema, InternalRow[] rows, List<Expression> filterExpressions) {
        this.table = table;
        this.readSchema = readSchema;
        this.rows = rows;
        this.filterExpressions = filterExpressions;
    }

    public InternalRow[] rows() {
        return this.rows;
    }

    public StructType readSchema() {
        return this.readSchema;
    }

    public String description() {
        return String.format("%s [filters=%s]", this.table, Spark3Util.describe(this.filterExpressions));
    }

    public String toString() {
        return String.format("IcebergLocalScan(table=%s, type=%s, filters=%s)", this.table, SparkSchemaUtil.convert(this.readSchema).asStruct(), this.filterExpressions);
    }
}

