/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.procedures;

import org.apache.iceberg.spark.procedures.BaseProcedure;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureParameter;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class FastForwardBranchProcedure
extends BaseProcedure {
    private static final ProcedureParameter[] PARAMETERS = new ProcedureParameter[]{ProcedureParameter.required("table", DataTypes.StringType), ProcedureParameter.required("branch", DataTypes.StringType), ProcedureParameter.required("to", DataTypes.StringType)};
    private static final StructType OUTPUT_TYPE = new StructType(new StructField[]{new StructField("branch_updated", DataTypes.StringType, false, Metadata.empty()), new StructField("previous_ref", DataTypes.LongType, true, Metadata.empty()), new StructField("updated_ref", DataTypes.LongType, false, Metadata.empty())});

    public static SparkProcedures.ProcedureBuilder builder() {
        return new BaseProcedure.Builder<FastForwardBranchProcedure>(){

            @Override
            protected FastForwardBranchProcedure doBuild() {
                return new FastForwardBranchProcedure(this.tableCatalog());
            }
        };
    }

    private FastForwardBranchProcedure(TableCatalog tableCatalog) {
        super(tableCatalog);
    }

    @Override
    public ProcedureParameter[] parameters() {
        return PARAMETERS;
    }

    @Override
    public StructType outputType() {
        return OUTPUT_TYPE;
    }

    @Override
    public InternalRow[] call(InternalRow args) {
        Identifier tableIdent = this.toIdentifier(args.getString(0), PARAMETERS[0].name());
        String source = args.getString(1);
        String target = args.getString(2);
        return this.modifyIcebergTable(tableIdent, table -> {
            long currentRef = table.currentSnapshot().snapshotId();
            table.manageSnapshots().fastForwardBranch(source, target).commit();
            long updatedRef = table.currentSnapshot().snapshotId();
            InternalRow outputRow = this.newInternalRow(UTF8String.fromString((String)source), currentRef, updatedRef);
            return new InternalRow[]{outputRow};
        });
    }

    @Override
    public String description() {
        return "FastForwardBranchProcedure";
    }
}

