/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.SizeBasedDataRewriter;
import org.apache.iceberg.spark.FileRewriteCoordinator;
import org.apache.iceberg.spark.ScanTaskSetManager;
import org.apache.iceberg.spark.SparkTableCache;
import org.apache.spark.sql.SparkSession;

abstract class SparkSizeBasedDataRewriter
extends SizeBasedDataRewriter {
    private final SparkSession spark;
    private final SparkTableCache tableCache = SparkTableCache.get();
    private final ScanTaskSetManager taskSetManager = ScanTaskSetManager.get();
    private final FileRewriteCoordinator coordinator = FileRewriteCoordinator.get();

    SparkSizeBasedDataRewriter(SparkSession spark, Table table) {
        super(table);
        this.spark = spark;
    }

    protected abstract void doRewrite(String var1, List<FileScanTask> var2);

    protected SparkSession spark() {
        return this.spark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<DataFile> rewrite(List<FileScanTask> group) {
        String groupId = UUID.randomUUID().toString();
        try {
            this.tableCache.add(groupId, this.table());
            this.taskSetManager.stageTasks(this.table(), groupId, group);
            this.doRewrite(groupId, group);
            Set set = this.coordinator.fetchNewFiles(this.table(), groupId);
            return set;
        }
        finally {
            this.tableCache.remove(groupId);
            this.taskSetManager.removeTasks(this.table(), groupId);
            this.coordinator.clearRewrite(this.table(), groupId);
        }
    }
}

