/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.impl.internal.statistics;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ehcache.core.InternalCache;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.core.statistics.TypedValueStatistic;
import org.ehcache.impl.internal.statistics.DefaultTierStatistics;
import org.ehcache.impl.internal.statistics.StatsUtils;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.derived.LatencySampling;
import org.terracotta.statistics.derived.MinMaxAverage;
import org.terracotta.statistics.extended.StatisticType;
import org.terracotta.statistics.jsr166e.LongAdder;
import org.terracotta.statistics.observer.ChainedOperationObserver;

class DefaultCacheStatistics
implements CacheStatistics {
    private volatile CompensatingCounters compensatingCounters = CompensatingCounters.empty();
    private final OperationStatistic<CacheOperationOutcomes.GetOutcome> get;
    private final OperationStatistic<CacheOperationOutcomes.PutOutcome> put;
    private final OperationStatistic<CacheOperationOutcomes.RemoveOutcome> remove;
    private final OperationStatistic<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsent;
    private final OperationStatistic<CacheOperationOutcomes.ReplaceOutcome> replace;
    private final OperationStatistic<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemove;
    private final Map<BulkOps, LongAdder> bulkMethodEntries;
    private final LatencyMonitor<CacheOperationOutcomes.GetOutcome> averageGetTime;
    private final LatencyMonitor<CacheOperationOutcomes.PutOutcome> averagePutTime;
    private final LatencyMonitor<CacheOperationOutcomes.RemoveOutcome> averageRemoveTime;
    private final Map<String, TierStatistics> tierStatistics;
    private final TierStatistics lowestTier;
    private final Map<String, TypedValueStatistic> knownStatistics;

    public DefaultCacheStatistics(InternalCache<?, ?> cache) {
        this.bulkMethodEntries = cache.getBulkMethodEntries();
        this.get = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.GetOutcome.class, "get");
        this.put = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutOutcome.class, "put");
        this.remove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.RemoveOutcome.class, "remove");
        this.putIfAbsent = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.PutIfAbsentOutcome.class, "putIfAbsent");
        this.replace = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ReplaceOutcome.class, "replace");
        this.conditionalRemove = StatsUtils.findOperationStatisticOnChildren(cache, CacheOperationOutcomes.ConditionalRemoveOutcome.class, "conditionalRemove");
        this.averageGetTime = new LatencyMonitor<CacheOperationOutcomes.GetOutcome>(EnumSet.allOf(CacheOperationOutcomes.GetOutcome.class));
        this.get.addDerivedStatistic((CacheOperationOutcomes.GetOutcome)((Object)this.averageGetTime));
        this.averagePutTime = new LatencyMonitor<CacheOperationOutcomes.PutOutcome>(EnumSet.allOf(CacheOperationOutcomes.PutOutcome.class));
        this.put.addDerivedStatistic((CacheOperationOutcomes.PutOutcome)((Object)this.averagePutTime));
        this.averageRemoveTime = new LatencyMonitor<CacheOperationOutcomes.RemoveOutcome>(EnumSet.allOf(CacheOperationOutcomes.RemoveOutcome.class));
        this.remove.addDerivedStatistic((CacheOperationOutcomes.RemoveOutcome)((Object)this.averageRemoveTime));
        String[] tierNames = StatsUtils.findTiers(cache);
        String lowestTierName = StatsUtils.findLowestTier(tierNames);
        DefaultTierStatistics lowestTier = null;
        this.tierStatistics = new HashMap<String, TierStatistics>(tierNames.length);
        for (String tierName : tierNames) {
            DefaultTierStatistics tierStatistics = new DefaultTierStatistics(cache, tierName);
            this.tierStatistics.put(tierName, tierStatistics);
            if (!lowestTierName.equals(tierName)) continue;
            lowestTier = tierStatistics;
        }
        this.lowestTier = lowestTier;
        this.knownStatistics = this.createKnownStatistics();
    }

    private Map<String, TypedValueStatistic> createKnownStatistics() {
        HashMap<String, TypedValueStatistic> knownStatistics = new HashMap<String, TypedValueStatistic>(30);
        knownStatistics.put("Cache:HitCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheHits();
            }
        });
        knownStatistics.put("Cache:MissCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheMisses();
            }
        });
        knownStatistics.put("Cache:PutCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCachePuts();
            }
        });
        knownStatistics.put("Cache:UpdateCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheUpdates();
            }
        });
        knownStatistics.put("Cache:RemovalCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheRemovals();
            }
        });
        knownStatistics.put("Cache:EvictionCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheEvictions();
            }
        });
        knownStatistics.put("Cache:ExpirationCount", new TypedValueStatistic(StatisticType.COUNTER){

            @Override
            public Number value() {
                return DefaultCacheStatistics.this.getCacheExpirations();
            }
        });
        for (TierStatistics tier : this.tierStatistics.values()) {
            knownStatistics.putAll(tier.getKnownStatistics());
        }
        return Collections.unmodifiableMap(knownStatistics);
    }

    @Override
    public Map<String, TypedValueStatistic> getKnownStatistics() {
        return this.knownStatistics;
    }

    @Override
    public Map<String, TierStatistics> getTierStatistics() {
        return Collections.unmodifiableMap(this.tierStatistics);
    }

    @Override
    public void clear() {
        this.compensatingCounters = this.compensatingCounters.snapshot(this);
        this.averageGetTime.clear();
        this.averagePutTime.clear();
        this.averageRemoveTime.clear();
        for (TierStatistics t : this.tierStatistics.values()) {
            t.clear();
        }
    }

    @Override
    public long getCacheHits() {
        return DefaultCacheStatistics.normalize(this.getHits() - this.compensatingCounters.cacheHits);
    }

    @Override
    public float getCacheHitPercentage() {
        long cacheHits = this.getCacheHits();
        return DefaultCacheStatistics.normalize((float)cacheHits / (float)(cacheHits + this.getCacheMisses())) * 100.0f;
    }

    @Override
    public long getCacheMisses() {
        return DefaultCacheStatistics.normalize(this.getMisses() - this.compensatingCounters.cacheMisses);
    }

    @Override
    public float getCacheMissPercentage() {
        long cacheMisses = this.getCacheMisses();
        return DefaultCacheStatistics.normalize((float)cacheMisses / (float)(this.getCacheHits() + cacheMisses)) * 100.0f;
    }

    @Override
    public long getCacheGets() {
        return DefaultCacheStatistics.normalize(this.getHits() + this.getMisses() - this.compensatingCounters.cacheGets);
    }

    @Override
    public long getCachePuts() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.PUT_ALL) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.PUT)) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.UPDATED)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cachePuts);
    }

    @Override
    public long getCacheUpdates() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.UPDATE_ALL) + this.put.sum(EnumSet.of(CacheOperationOutcomes.PutOutcome.UPDATED)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT)) - this.compensatingCounters.cacheUpdates);
    }

    @Override
    public long getCacheRemovals() {
        return DefaultCacheStatistics.normalize(this.getBulkCount(BulkOps.REMOVE_ALL) + this.remove.sum(EnumSet.of(CacheOperationOutcomes.RemoveOutcome.SUCCESS)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS)) - this.compensatingCounters.cacheRemovals);
    }

    @Override
    public long getCacheEvictions() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getEvictions());
    }

    @Override
    public long getCacheExpirations() {
        return DefaultCacheStatistics.normalize(this.lowestTier.getExpirations());
    }

    @Override
    public float getCacheAverageGetTime() {
        return (float)this.averageGetTime.value();
    }

    @Override
    public float getCacheAveragePutTime() {
        return (float)this.averagePutTime.value();
    }

    @Override
    public float getCacheAverageRemoveTime() {
        return (float)this.averageRemoveTime.value();
    }

    private long getMisses() {
        return this.getBulkCount(BulkOps.GET_ALL_MISS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.MISS)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.PUT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING));
    }

    private long getHits() {
        return this.getBulkCount(BulkOps.GET_ALL_HITS) + this.get.sum(EnumSet.of(CacheOperationOutcomes.GetOutcome.HIT)) + this.putIfAbsent.sum(EnumSet.of(CacheOperationOutcomes.PutIfAbsentOutcome.HIT)) + this.replace.sum(EnumSet.of(CacheOperationOutcomes.ReplaceOutcome.HIT, CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT)) + this.conditionalRemove.sum(EnumSet.of(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS, CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT));
    }

    private long getBulkCount(BulkOps bulkOps) {
        return this.bulkMethodEntries.get((Object)bulkOps).longValue();
    }

    private static long normalize(long value) {
        return Math.max(0L, value);
    }

    private static float normalize(float value) {
        if (Float.isNaN(value)) {
            return 0.0f;
        }
        return Math.min(1.0f, Math.max(0.0f, value));
    }

    private static class LatencyMonitor<T extends Enum<T>>
    implements ChainedOperationObserver<T> {
        private final LatencySampling<T> sampling;
        private volatile MinMaxAverage average;

        public LatencyMonitor(Set<T> targets) {
            this.sampling = new LatencySampling<T>(targets, 1.0);
            this.average = new MinMaxAverage();
            this.sampling.addDerivedStatistic(this.average);
        }

        @Override
        public void begin(long time) {
            this.sampling.begin(time);
        }

        @Override
        public void end(long time, T result) {
            this.sampling.end(time, result);
        }

        @Override
        public void end(long time, T result, long ... parameters) {
            this.sampling.end(time, result, parameters);
        }

        public double value() {
            Double value = this.average.mean();
            if (value == null) {
                return 0.0;
            }
            return value / 1000.0;
        }

        public synchronized void clear() {
            this.sampling.removeDerivedStatistic(this.average);
            this.average = new MinMaxAverage();
            this.sampling.addDerivedStatistic(this.average);
        }
    }

    private static class CompensatingCounters {
        final long cacheHits;
        final long cacheMisses;
        final long cacheGets;
        final long cachePuts;
        final long cacheRemovals;
        final long cacheUpdates;

        private CompensatingCounters(long cacheHits, long cacheMisses, long cacheGets, long cachePuts, long cacheRemovals, long cacheUpdates) {
            this.cacheHits = cacheHits;
            this.cacheMisses = cacheMisses;
            this.cacheGets = cacheGets;
            this.cachePuts = cachePuts;
            this.cacheRemovals = cacheRemovals;
            this.cacheUpdates = cacheUpdates;
        }

        static CompensatingCounters empty() {
            return new CompensatingCounters(0L, 0L, 0L, 0L, 0L, 0L);
        }

        CompensatingCounters snapshot(DefaultCacheStatistics statistics) {
            return new CompensatingCounters(this.cacheHits + statistics.getHits(), this.cacheMisses + statistics.getMisses(), this.cacheGets + statistics.getCacheGets(), this.cachePuts + statistics.getCachePuts(), this.cacheRemovals + statistics.getCacheRemovals(), this.cacheUpdates + statistics.getCacheUpdates());
        }
    }
}

