/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.table;

import org.apache.commons.lang3.StringUtils;

public enum DistributionHashMode {
    NONE("none", false, false),
    PRIMARY_KEY("primary-key", true, false),
    PARTITION_KEY("partition-key", false, true),
    PRIMARY_PARTITION_KEY("primary-partition-key", true, true),
    AUTO("auto", true, true);

    private final String desc;
    private final boolean supportPrimaryKey;
    private final boolean supportPartition;

    private DistributionHashMode(String desc, boolean supportPrimaryKey, boolean supportPartition) {
        this.desc = desc;
        this.supportPrimaryKey = supportPrimaryKey;
        this.supportPartition = supportPartition;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isSupportPrimaryKey() {
        return this.supportPrimaryKey;
    }

    public boolean isSupportPartition() {
        return this.supportPartition;
    }

    public boolean mustByPrimaryKey() {
        return this.supportPrimaryKey && this.strict();
    }

    public boolean mustByPartition() {
        return this.supportPartition && this.strict();
    }

    private boolean strict() {
        return this != AUTO;
    }

    public static DistributionHashMode valueOfDesc(String desc) {
        for (DistributionHashMode value : DistributionHashMode.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)value.getDesc(), (CharSequence)desc)) continue;
            return value;
        }
        throw new IllegalArgumentException("unknown ShufflePolicyType " + desc);
    }

    public static DistributionHashMode autoSelect(boolean primaryKeyExist, boolean partitionExist) {
        if (primaryKeyExist) {
            if (partitionExist) {
                return PRIMARY_PARTITION_KEY;
            }
            return PRIMARY_KEY;
        }
        if (partitionExist) {
            return PARTITION_KEY;
        }
        return NONE;
    }
}

