/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.scan;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.amoro.data.DataFileType;
import org.apache.amoro.data.DataTreeNode;
import org.apache.amoro.scan.KeyedTableScanTask;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.shade.guava32.com.google.common.base.MoreObjects;
import org.apache.amoro.utils.FileScanTaskUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeFileScanTask
implements KeyedTableScanTask {
    private static final Logger LOG = LoggerFactory.getLogger(NodeFileScanTask.class);
    private List<MixedFileScanTask> baseTasks = new ArrayList<MixedFileScanTask>();
    private List<MixedFileScanTask> insertTasks = new ArrayList<MixedFileScanTask>();
    private List<MixedFileScanTask> deleteFiles = new ArrayList<MixedFileScanTask>();
    private long cost = 0L;
    private final long openFileCost;
    private DataTreeNode treeNode;
    private long rowNums = 0L;

    public NodeFileScanTask() {
        this.openFileCost = 0x400000L;
    }

    public NodeFileScanTask(DataTreeNode treeNode) {
        this.openFileCost = 0x400000L;
        this.treeNode = treeNode;
    }

    public NodeFileScanTask(List<MixedFileScanTask> allTasks) {
        this.openFileCost = 0x400000L;
        this.baseTasks = allTasks.stream().filter(t -> t.file().type() == DataFileType.BASE_FILE).collect(Collectors.toList());
        this.insertTasks = allTasks.stream().filter(t -> t.file().type() == DataFileType.INSERT_FILE).collect(Collectors.toList());
        this.deleteFiles = allTasks.stream().filter(t -> t.file().type() == DataFileType.EQ_DELETE_FILE).collect(Collectors.toList());
        Stream.concat(this.baseTasks.stream(), this.insertTasks.stream()).forEach(task -> {
            this.cost += Math.max(task.file().fileSizeInBytes(), this.openFileCost);
            this.rowNums += task.file().recordCount();
        });
    }

    public void setTreeNode(DataTreeNode treeNode) {
        this.treeNode = treeNode;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    @Override
    public long recordCount() {
        return this.rowNums;
    }

    @Override
    public List<MixedFileScanTask> baseTasks() {
        return this.baseTasks;
    }

    @Override
    public List<MixedFileScanTask> insertTasks() {
        return this.insertTasks;
    }

    @Override
    public List<MixedFileScanTask> mixedEquityDeletes() {
        return this.deleteFiles;
    }

    @Override
    public List<MixedFileScanTask> dataTasks() {
        return Stream.concat(this.baseTasks.stream(), this.insertTasks.stream()).collect(Collectors.toList());
    }

    public void addFile(MixedFileScanTask task) {
        DataFileType fileType = task.fileType();
        if (fileType == null) {
            LOG.warn("file type is null");
            return;
        }
        if (fileType == DataFileType.BASE_FILE || fileType == DataFileType.INSERT_FILE) {
            this.cost += Math.max(task.file().fileSizeInBytes(), this.openFileCost);
            this.rowNums += task.file().recordCount();
        }
        switch (fileType) {
            case BASE_FILE: {
                this.baseTasks.add(task);
                break;
            }
            case INSERT_FILE: {
                this.insertTasks.add(task);
                break;
            }
            case EQ_DELETE_FILE: {
                this.deleteFiles.add(task);
                break;
            }
            default: {
                LOG.warn("file type is {}, not add in node", (Object)fileType);
            }
        }
    }

    public void addTasks(List<MixedFileScanTask> files) {
        files.forEach(this::addFile);
    }

    public Boolean isDataNode() {
        return this.baseTasks.size() > 0 || this.insertTasks.size() > 0;
    }

    public Boolean isSameNode(long mask, long index) {
        return this.treeNode.mask() == mask && this.treeNode.index() == index;
    }

    public DataTreeNode treeNode() {
        return this.treeNode;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("\nbaseTasks", (Object)FileScanTaskUtil.toString(this.baseTasks)).add("\ninsertTasks", (Object)FileScanTaskUtil.toString(this.insertTasks)).add("\ndeleteFiles", (Object)FileScanTaskUtil.toString(this.deleteFiles)).toString();
    }
}

