/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing.scan;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.DefaultKeyedFile;
import org.apache.amoro.optimizing.scan.IcebergTableFileScanHelper;
import org.apache.amoro.optimizing.scan.TableFileScanHelper;
import org.apache.amoro.table.UnkeyedTable;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;

public class UnkeyedTableFileScanHelper
extends IcebergTableFileScanHelper {
    public UnkeyedTableFileScanHelper(UnkeyedTable table, long snapshotId) {
        super(table, snapshotId);
    }

    @Override
    protected TableFileScanHelper.FileScanResult buildFileScanResult(FileScanTask fileScanTask) {
        DataFile dataFile = this.wrapBaseFile((DataFile)fileScanTask.file());
        List<ContentFile<?>> deleteFiles = fileScanTask.deletes().stream().map(this::wrapDeleteFile).collect(Collectors.toList());
        return new TableFileScanHelper.FileScanResult(dataFile, deleteFiles);
    }

    private DataFile wrapBaseFile(DataFile dataFile) {
        return DefaultKeyedFile.parseBase(dataFile);
    }

    private ContentFile<?> wrapDeleteFile(DeleteFile deleteFile) {
        if (deleteFile.content() == FileContent.EQUALITY_DELETES) {
            throw new UnsupportedOperationException("optimizing unkeyed table not support equality-delete");
        }
        return deleteFile;
    }
}

