/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.optimizing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.amoro.data.PrimaryKeyedFile;
import org.apache.amoro.io.reader.AbstractKeyedDataReader;
import org.apache.amoro.io.reader.GenericKeyedDataReader;
import org.apache.amoro.optimizing.OptimizingDataReader;
import org.apache.amoro.optimizing.RewriteFilesInput;
import org.apache.amoro.scan.BasicMixedFileScanTask;
import org.apache.amoro.scan.MixedFileScanTask;
import org.apache.amoro.scan.NodeFileScanTask;
import org.apache.amoro.table.KeyedTable;
import org.apache.amoro.table.MixedTable;
import org.apache.amoro.table.PrimaryKeySpec;
import org.apache.amoro.utils.map.StructLikeCollections;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.types.Types;

public class MixedIcebergOptimizingDataReader
implements OptimizingDataReader {
    private final MixedTable table;
    private final StructLikeCollections structLikeCollections;
    private final RewriteFilesInput input;

    public MixedIcebergOptimizingDataReader(MixedTable table, StructLikeCollections structLikeCollections, RewriteFilesInput input) {
        this.table = table;
        this.structLikeCollections = structLikeCollections;
        this.input = input;
    }

    @Override
    public CloseableIterable<Record> readData() {
        AbstractKeyedDataReader<Record> reader = this.mixedTableDataReader(this.table.schema());
        CloseableIterator<Record> closeableIterator = reader.readData(this.nodeFileScanTask(this.input.rewrittenDataFilesForMixed()));
        return this.wrapIterator2Iterable(closeableIterator);
    }

    @Override
    public CloseableIterable<Record> readDeletedData() {
        Schema schema = new Schema(new Types.NestedField[]{MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION, org.apache.amoro.table.MetadataColumns.TREE_NODE_FIELD});
        AbstractKeyedDataReader<Record> reader = this.mixedTableDataReader(schema);
        return this.wrapIterator2Iterable(reader.readDeletedData(this.nodeFileScanTask(this.input.rePosDeletedDataFilesForMixed())));
    }

    @Override
    public void close() {
    }

    protected AbstractKeyedDataReader<Record> mixedTableDataReader(Schema requiredSchema) {
        PrimaryKeySpec primaryKeySpec = PrimaryKeySpec.noPrimaryKey();
        if (this.table.isKeyedTable()) {
            KeyedTable keyedTable = this.table.asKeyedTable();
            primaryKeySpec = keyedTable.primaryKeySpec();
        }
        return new GenericKeyedDataReader(this.table.io(), this.table.schema(), requiredSchema, primaryKeySpec, this.table.properties().get("schema.name-mapping.default"), false, IdentityPartitionConverters::convertConstant, null, false, this.structLikeCollections);
    }

    private NodeFileScanTask nodeFileScanTask(List<PrimaryKeyedFile> dataFiles) {
        List<DeleteFile> posDeleteList = this.input.positionDeleteForMixed();
        List<PrimaryKeyedFile> equlityDeleteList = this.input.equalityDeleteForMixed();
        ArrayList<PrimaryKeyedFile> allTaskFiles = new ArrayList<PrimaryKeyedFile>();
        allTaskFiles.addAll(equlityDeleteList);
        allTaskFiles.addAll(dataFiles);
        List<MixedFileScanTask> fileScanTasks = allTaskFiles.stream().map(file -> new BasicMixedFileScanTask((PrimaryKeyedFile)file, posDeleteList, this.table.spec())).collect(Collectors.toList());
        return new NodeFileScanTask(fileScanTasks);
    }

    private CloseableIterable<Record> wrapIterator2Iterable(final CloseableIterator<Record> iterator) {
        return new CloseableIterable<Record>(){

            public CloseableIterator<Record> iterator() {
                return iterator;
            }

            public void close() throws IOException {
                iterator.close();
            }
        };
    }
}

