/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.amoro.op.MixedAppendFiles;
import org.apache.amoro.op.MixedDeleteFiles;
import org.apache.amoro.op.MixedOverwriteFiles;
import org.apache.amoro.op.MixedReplacePartitions;
import org.apache.amoro.op.MixedRewriteFiles;
import org.apache.amoro.op.MixedRowDelta;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;

public class MixedTransaction
implements Transaction {
    private final MixedTable mixedTable;
    private final Transaction transaction;
    private final Table transactionTable;

    public MixedTransaction(MixedTable mixedTable, Transaction transaction) {
        this.mixedTable = mixedTable;
        this.transaction = transaction;
        this.transactionTable = new TransactionTable();
    }

    public Table table() {
        return this.transactionTable;
    }

    public UpdateSchema updateSchema() {
        return this.transaction.updateSchema();
    }

    public UpdatePartitionSpec updateSpec() {
        return this.transaction.updateSpec();
    }

    public UpdateProperties updateProperties() {
        return this.transaction.updateProperties();
    }

    public ReplaceSortOrder replaceSortOrder() {
        return this.transaction.replaceSortOrder();
    }

    public UpdateLocation updateLocation() {
        return this.transaction.updateLocation();
    }

    public AppendFiles newAppend() {
        return (AppendFiles)MixedAppendFiles.buildFor(this.mixedTable, false).inTransaction(this.transaction).build();
    }

    public AppendFiles newFastAppend() {
        return (AppendFiles)MixedAppendFiles.buildFor(this.mixedTable, true).inTransaction(this.transaction).build();
    }

    public RewriteFiles newRewrite() {
        return (RewriteFiles)MixedRewriteFiles.buildFor(this.mixedTable).inTransaction(this.transaction).build();
    }

    public RewriteManifests rewriteManifests() {
        return this.transaction.rewriteManifests();
    }

    public OverwriteFiles newOverwrite() {
        return (OverwriteFiles)MixedOverwriteFiles.buildFor(this.mixedTable).inTransaction(this.transaction).build();
    }

    public RowDelta newRowDelta() {
        return (RowDelta)MixedRowDelta.buildFor(this.mixedTable).inTransaction(this.transaction).build();
    }

    public ReplacePartitions newReplacePartitions() {
        return (ReplacePartitions)MixedReplacePartitions.buildFor(this.mixedTable).inTransaction(this.transaction).build();
    }

    public DeleteFiles newDelete() {
        return (DeleteFiles)MixedDeleteFiles.buildFor(this.mixedTable).inTransaction(this.transaction).build();
    }

    public ExpireSnapshots expireSnapshots() {
        return this.transaction.expireSnapshots();
    }

    public UpdateStatistics updateStatistics() {
        return this.transaction.updateStatistics();
    }

    public void commitTransaction() {
        this.transaction.commitTransaction();
    }

    class TransactionTable
    implements Table,
    HasTableOperations,
    Serializable {
        Table transactionTable;

        public TransactionTable() {
            this.transactionTable = MixedTransaction.this.transaction.table();
        }

        public TableOperations operations() {
            if (this.transactionTable instanceof HasTableOperations) {
                return ((HasTableOperations)this.transactionTable).operations();
            }
            throw new IllegalStateException("table does not support operations");
        }

        public String name() {
            return this.transactionTable.name();
        }

        public void refresh() {
            this.transactionTable.refresh();
        }

        public TableScan newScan() {
            return this.transactionTable.newScan();
        }

        public Schema schema() {
            return this.transactionTable.schema();
        }

        public Map<Integer, Schema> schemas() {
            return this.transactionTable.schemas();
        }

        public PartitionSpec spec() {
            return this.transactionTable.spec();
        }

        public Map<Integer, PartitionSpec> specs() {
            return this.transactionTable.specs();
        }

        public SortOrder sortOrder() {
            return this.transactionTable.sortOrder();
        }

        public Map<Integer, SortOrder> sortOrders() {
            return this.transactionTable.sortOrders();
        }

        public Map<String, String> properties() {
            return this.transactionTable.properties();
        }

        public String location() {
            return this.transactionTable.location();
        }

        public Snapshot currentSnapshot() {
            return this.transactionTable.currentSnapshot();
        }

        public Snapshot snapshot(long snapshotId) {
            return this.transactionTable.snapshot(snapshotId);
        }

        public Iterable<Snapshot> snapshots() {
            return this.transactionTable.snapshots();
        }

        public List<HistoryEntry> history() {
            return this.transactionTable.history();
        }

        public UpdateSchema updateSchema() {
            return this.transactionTable.updateSchema();
        }

        public UpdatePartitionSpec updateSpec() {
            return this.transactionTable.updateSpec();
        }

        public UpdateProperties updateProperties() {
            return this.transactionTable.updateProperties();
        }

        public ReplaceSortOrder replaceSortOrder() {
            return this.transactionTable.replaceSortOrder();
        }

        public UpdateLocation updateLocation() {
            return this.transactionTable.updateLocation();
        }

        public AppendFiles newAppend() {
            return this.transactionTable.newAppend();
        }

        public AppendFiles newFastAppend() {
            return this.transactionTable.newFastAppend();
        }

        public RewriteFiles newRewrite() {
            return this.transactionTable.newRewrite();
        }

        public RewriteManifests rewriteManifests() {
            return this.transactionTable.rewriteManifests();
        }

        public OverwriteFiles newOverwrite() {
            return this.transactionTable.newOverwrite();
        }

        public RowDelta newRowDelta() {
            return this.transactionTable.newRowDelta();
        }

        public ReplacePartitions newReplacePartitions() {
            return this.transactionTable.newReplacePartitions();
        }

        public DeleteFiles newDelete() {
            return this.transactionTable.newDelete();
        }

        public ExpireSnapshots expireSnapshots() {
            return this.transactionTable.expireSnapshots();
        }

        public ManageSnapshots manageSnapshots() {
            return this.transactionTable.manageSnapshots();
        }

        public Transaction newTransaction() {
            return this.transactionTable.newTransaction();
        }

        public FileIO io() {
            return this.transactionTable.io();
        }

        public EncryptionManager encryption() {
            return this.transactionTable.encryption();
        }

        public LocationProvider locationProvider() {
            return this.transactionTable.locationProvider();
        }

        public List<StatisticsFile> statisticsFiles() {
            return this.transactionTable.statisticsFiles();
        }

        public Map<String, SnapshotRef> refs() {
            return this.transactionTable.refs();
        }

        public UpdateStatistics updateStatistics() {
            return this.transactionTable.updateStatistics();
        }

        public String toString() {
            return this.transactionTable.toString();
        }
    }
}

