/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.amoro.op.MixedUpdate;
import org.apache.amoro.table.MixedTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;

public class MixedRewriteFiles
extends MixedUpdate<RewriteFiles>
implements RewriteFiles {
    private final RewriteFiles rewriteFiles;

    public static Builder buildFor(MixedTable table) {
        return new Builder(table);
    }

    protected MixedRewriteFiles(MixedTable table, RewriteFiles rewriteFiles) {
        super(table, rewriteFiles);
        this.rewriteFiles = rewriteFiles;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd) {
        this.rewriteFiles.rewriteFiles(filesToDelete, filesToAdd);
        filesToAdd.forEach(this::addIcebergDataFile);
        filesToDelete.forEach(this::deleteIcebergDataFile);
        return this;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> filesToDelete, Set<DataFile> filesToAdd, long sequenceNumber) {
        this.rewriteFiles.rewriteFiles(filesToDelete, filesToAdd, sequenceNumber);
        filesToAdd.forEach(this::addIcebergDataFile);
        filesToDelete.forEach(this::deleteIcebergDataFile);
        return this;
    }

    public RewriteFiles rewriteFiles(Set<DataFile> dataFilesToReplace, Set<DeleteFile> deleteFilesToReplace, Set<DataFile> dataFilesToAdd, Set<DeleteFile> deleteFilesToAdd) {
        this.rewriteFiles.rewriteFiles(dataFilesToReplace, deleteFilesToReplace, dataFilesToAdd, deleteFilesToAdd);
        dataFilesToAdd.forEach(this::addIcebergDataFile);
        dataFilesToReplace.forEach(this::deleteIcebergDataFile);
        deleteFilesToAdd.forEach(this::addIcebergDeleteFile);
        deleteFilesToReplace.forEach(this::deleteIcebergDeleteFile);
        return this;
    }

    public RewriteFiles deleteFile(DataFile dataFile) {
        this.deleteIcebergDataFile(dataFile);
        this.rewriteFiles.deleteFile(dataFile);
        return this;
    }

    public RewriteFiles deleteFile(DeleteFile deleteFile) {
        this.deleteIcebergDeleteFile(deleteFile);
        this.rewriteFiles.deleteFile(deleteFile);
        return this;
    }

    public RewriteFiles validateFromSnapshot(long snapshotId) {
        this.rewriteFiles.validateFromSnapshot(snapshotId);
        return this;
    }

    public RewriteFiles addFile(DataFile dataFile) {
        this.rewriteFiles.addFile(dataFile);
        return this;
    }

    public RewriteFiles addFile(DeleteFile deleteFile) {
        this.rewriteFiles.addFile(deleteFile);
        return this;
    }

    public RewriteFiles addFile(DeleteFile deleteFile, long dataSequenceNumber) {
        this.rewriteFiles.addFile(deleteFile, dataSequenceNumber);
        return this;
    }

    public RewriteFiles dataSequenceNumber(long sequenceNumber) {
        this.rewriteFiles.dataSequenceNumber(sequenceNumber);
        return this;
    }

    @Override
    protected RewriteFiles self() {
        return this;
    }

    public static class Builder
    extends MixedUpdate.Builder<MixedRewriteFiles, RewriteFiles> {
        private Builder(MixedTable table) {
            super(table);
        }

        @Override
        protected MixedRewriteFiles updateWithWatermark(Transaction transaction, boolean autoCommitTransaction) {
            return new MixedRewriteFiles(this.table, transaction.newRewrite());
        }

        @Override
        protected MixedRewriteFiles updateWithoutWatermark(Supplier<RewriteFiles> delegateSupplier) {
            return new MixedRewriteFiles(this.table, delegateSupplier.get());
        }

        @Override
        protected Supplier<RewriteFiles> transactionDelegateSupplier(Transaction transaction) {
            return () -> ((Transaction)transaction).newRewrite();
        }

        @Override
        protected Supplier<RewriteFiles> tableStoreDelegateSupplier(Table tableStore) {
            return () -> ((Table)tableStore).newRewrite();
        }
    }
}

