/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.op;

import org.apache.amoro.io.AuthenticatedFileIO;
import org.apache.amoro.utils.IcebergInMemoryLockManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.LockManager;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.hadoop.HadoopTableOperations;
import org.apache.iceberg.io.FileIO;

public class MixedHadoopTableOperations
extends HadoopTableOperations {
    private final AuthenticatedFileIO authenticatedFileIO;

    public MixedHadoopTableOperations(Path location, AuthenticatedFileIO fileIO, Configuration conf) {
        super(location, (FileIO)fileIO, conf, (LockManager)IcebergInMemoryLockManager.instance());
        this.authenticatedFileIO = fileIO;
    }

    public TableMetadata refresh() {
        return this.authenticatedFileIO.doAs(() -> super.refresh());
    }

    public void commit(TableMetadata base, TableMetadata metadata) {
        this.authenticatedFileIO.doAs(() -> {
            try {
                super.commit(base, metadata);
            }
            catch (CommitFailedException e) {
                if (e.getCause() != null) {
                    throw new CommitStateUnknownException((Throwable)e);
                }
                throw e;
            }
            return null;
        });
    }
}

