/*
 * Decompiled with CFR 0.152.
 */
package org.apache.amoro.log;

import java.util.Arrays;
import org.apache.amoro.log.Bytes;
import org.apache.amoro.log.LogData;
import org.apache.amoro.log.MessageBytes;
import org.apache.amoro.shade.guava32.com.google.common.base.Preconditions;

public enum FormatVersion {
    FORMAT_VERSION_V1(new MessageBytes().append(LogData.MAGIC_NUMBER).append((byte)1).toBytes());

    byte[] version;
    byte versionNum;
    byte[] magicNum;

    private FormatVersion(byte[] version) {
        Preconditions.checkArgument((null != version && version.length == 4 ? 1 : 0) != 0, (Object)"format version is null or length is not equal to 4.");
        this.version = version;
        this.magicNum = Bytes.subByte(version, 0, 3);
        this.versionNum = Bytes.subByte(version, 3, 1)[0];
    }

    public byte[] asBytes() {
        return this.version;
    }

    public String asString() {
        return new String(this.magicNum) + this.versionNum;
    }

    public byte getVersionNum() {
        return this.versionNum;
    }

    public static FormatVersion fromBytes(byte[] data) {
        for (FormatVersion formatVersion : FormatVersion.values()) {
            byte[] expected = formatVersion.asBytes();
            if (!Arrays.equals(expected, data)) continue;
            return formatVersion;
        }
        return null;
    }
}

